/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java;

import org.openide.text.Line;
import org.openide.filesystems.FileObject;

/*
 * This class represents a single error encountered when parsing
 * a java file.
 * <p>
 * @author Tor Norbye <tor@netbeans.org>
 * @deprecated
 */

abstract public class ParserMessage {
    /** Represents a message with severity "error" (e.g. makes
     * compilation fail. 
     */
    final public static Object ERROR = 
        new String("Error"); // new: don't intern. Just needs to be a unique // NOI18N
                        // object, but String has a nice toString() behavior

    /** Represents a message with severity "warning" (e.g.
     * compilation can proceed)
     */
    final public static Object WARNING = new String("Warning"); // NOI18N

    /** Return the severity of the error; it's either
     *   ERROR or WARNING.
     */
    abstract public Object getSeverity();
    
    /** Return the line number on which the error occurred.
     *  @return the line number on which the error occurred.
     */
    abstract public int getLineNumber();
    
    /** Return the column number within the line on which the error occurred.
     *  @return the column number within the line on which the error occurred.
     */
    abstract public int getColumn();
        
    /** Return the text description of the error
     * @return the text description of the error
     */
    abstract public String getDescription();
}

