/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java;

import java.util.*;
import javax.jmi.reflect.InvalidObjectException;

import org.openide.src.SourceElement;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.ErrorInfo;
import org.netbeans.jmi.javamodel.ErrorTypeEnum;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.ParsingListener;

/** The public interface for parsing of java sources. This class contains listener
* interface and the event class, also the methods for registration and unregistration
* of the listener.
*
* @author Petr Hamernik
* @deprecated
*/
public class Parsing extends Object {

    private static ParsingListener listener = new ParsingListener() {
        public void resourceParsed(final Resource rsc) {
            try {
                JavaDataObject jdo = (JavaDataObject) JavaMetamodel.getManager().getDataObject(rsc);
                if (jdo != null)
                    fireEvent(jdo, rsc);
            } catch (InvalidObjectException e) {
                // ignore
            }
        }
    };

    static {
        JavaMetamodel.addParsingListener(listener);
    }

    private static class ParserMessageImpl extends ParserMessage {
        private final ErrorInfo errorInfo;

        ParserMessageImpl(ErrorInfo ei) {
            errorInfo = ei;
        }

        public Object getSeverity() {
            return errorInfo.getSeverity() == ErrorTypeEnum.WARNING ? ParserMessage.WARNING : ParserMessage.ERROR;
        }

        public int getLineNumber() {
            return errorInfo.getLineNumber();
        }

        public int getColumn() {
            return errorInfo.getColumn();
        }

        public String getDescription() {
            return errorInfo.getDescription();
        }
    }

    /** Add the specific listener to the list of global parsing listeners.
    * @param l listener to add
    */
    public static void addParsingListener(Listener l) {
        synchronized (JavaDataLoader.parsingListeners) {
            JavaDataLoader.parsingListeners.add(l);
        }
    }

    /** Remove the specific listener from the list of global parsing listeners.
    * @param l listener to remove
    */
    public static void removeParsingListener(Listener l) {
        synchronized (JavaDataLoader.parsingListeners) {
            JavaDataLoader.parsingListeners.remove(l);
        }
    }

    /** Fire the event for specified JavaDataObject.
    */
    public static void fireEvent(JavaDataObject jdo,
                                 Resource rsc) {
        Event evt = new Event(jdo, rsc);
        Iterator it = null;
        synchronized (JavaDataLoader.parsingListeners) {
            List list = (List) JavaDataLoader.parsingListeners.clone();
            it = list.iterator();
        }
        while (it.hasNext()) {
            ((Listener) it.next()).objectParsed(evt);
        }
    }

    /** Fire the event for specified JavaDataObject.
    */
    public static void fireEvent(JavaDataObject jdo,
                                 Collection messages) {
        Event evt = new Event(jdo, messages);
        Iterator it = null;
        synchronized (JavaDataLoader.parsingListeners) {
            List list = (List) JavaDataLoader.parsingListeners.clone();
            it = list.iterator();
        }
        while (it.hasNext()) {
            ((Listener) it.next()).objectParsed(evt);
        }
    }

    /** The listener interface for everybody who want to control all
    * parsed JavaDataObjects.
    */
    public static interface Listener extends EventListener {
        /** Method which is called everytime when some object is parsed.
        * @param evt The event with the details.
        */
        public void objectParsed(Event evt);
    }

    /** The event class used in Listener.
    */
    public static class Event extends EventObject {
        static final long serialVersionUID =8512232095851109211L;
        private Collection messages;
        private final Resource rsc;
        /** Construct the new Event.
        * @param jdo JavaDataObject which is the source of the event.
         * @param msg the error messages from the parser
         */
        Event(JavaDataObject jdo, Collection msg) {
            super(jdo);
            messages = msg;
            this.rsc = null;
        }

        Event (JavaDataObject jdo, Resource rsc) {
            super(jdo);
            this.rsc = rsc;
        }

        /** @return the data object which is the source of the event.
        */
        public JavaDataObject getJavaDataObject() {
            return (JavaDataObject) getSource();
        }

        /** @return the source element which was parsed.
        */
        public SourceElement getSourceElement() {
            return getJavaDataObject().getSource();
        }

        /** @return the errors encountered for this source. May be
            null if there are no associated errors. */
        public synchronized ParserMessage[] getMessages() {
            if (messages == null) {
                if (rsc == null) {
                    return null;
                }
                List errors = rsc.getErrors();
                messages = new ArrayList();
                for (Iterator it = errors.iterator(); it.hasNext();) {
                    messages.add(new ParserMessageImpl((ErrorInfo) it.next()));
                }
            }
            // PENDING Just return messages, or make defensive copy?
            ParserMessage[] copy = new ParserMessage[messages.size()];
            messages.toArray(copy);
            return copy;
        }

    }
}
