/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.bridge;

import java.util.EventListener;
import java.util.Set;
import java.util.Map;

import org.openide.src.SourceException;

/**
 * The interface defines a listener that listens for outcome of atomic operations
 * on the model. CommitListeners are contacted before the atomic operation completes
 * and are given a chance to abort the whole operation. The commit is simple two-phase
 * one; in the first phase, all listeners are contacted and queried to confirm 
 * the change integrity. In the second phase, if no listener aborts the operation,
 * the listeners are notified that the operation completed successfully. There is
 * no notification that the operation was aborted, currently.
 *
 * @author  Svatopluk Dedic <mailto:sdedic@netbeans.org>
 * @version 0.1
 */
public interface CommitListener extends EventListener {
    /**
     * Notifies the listener about changes that are made to the model. The method
     * is only a notification message and can not abort the operation, for that
     * purposes, use {@link #queryCommitChanges} instead.<P>
     * The method is called just before the write lock on the model is released.
     * Avoid lengthy operations from within this method, use RequestProcessor, if necessary.
     * Recipients are not allowed to alter the source model.
     * @param created set of elements that were created within the atomic operation.
     * @param removed set of elements that were removed during the operation
     * @param changed map indexed by elements that were changed during the operation. 
     * values of the map are elements of the same type containing saved state of
     * the changed element.
     */
    public void changesCommited(Set created, Set removed, Map changed);

    public interface Veto extends CommitListener {
        /**
         * Asks the listener whether it is satisfied with the changes made so far.
         * Recipients are not allowed to alter the source model.
         * @param created set of elements that were created within the atomic operation.
         * @param removed set of elements that were removed during the operation
         * @param changed map indexed by elements that were changed during the operation. 
         * values of the map are elements of the same type containing saved state of
         * the changed element.
         * @param zero, if the operation is going out of the write lock; if zero, this is
         * the last chance to prevent the modification from being done.
         * @throws SourceException if the listener is not satisfied with impact of the
         * changes on the model.
         */
        public void queryCommitChanges(Set created, Set removed, Map changed,
            int lockLevel) 
            throws SourceException;
    }    
}
