/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.bridge;

import java.lang.reflect.Modifier;
import java.beans.PropertyChangeEvent;

import org.openide.src.*;
import org.netbeans.jmi.javamodel.Constructor;

class ConstructorElementImpl extends CallableImpl {
    
    private ElementImpl.ElementListener callableListener;
    
    private static final long serialVersionUID = 3379682002192002288L;
        
    ConstructorElementImpl(DefaultLangModel model, Constructor constructor) {
        super(model, constructor);
    }
    
    protected void setParent(ElementImpl impl) {
        if (impl instanceof ClassElementImpl) {
            this.declaringClassImpl = (ClassElementImpl)impl;
        }
    }        
    
    public Object readResolve() {
        return null;
    }
    
    public void connectListener () {
        callableListener = new CallableImpl.CallableListener (this);
        callableListener.connect ();
    }
    
    protected Identifier createName(String dummy) {
        if (getDeclaringImpl() != null)
            return Identifier.create(getDeclaringImpl().getName().getSourceName());
        else
            return super.createName(dummy);
    }
    
    /** Imposes additional constraint on the constructor: the declaring class'
     * name must match the constructor's name. 
     */
    protected void checkNameConstraints(Identifier name) throws SourceException {
        super.checkNameConstraints(name);
        // additional constraint:
        // PENDING: do not check depending on model lock type.
        if (!name.getName().equals(getDeclaringImpl().getName().getName())) {
            throw new SourceException("Invalid constructor name: " + name); // NOI18N
        }
    }    
    
    /** Check for modifiers disallowed on a constructor: static, strictfp, final,
     * synchronized, abstract
     */
    protected void checkModifierConstraints(int newMods) throws SourceException {
        super.checkModifierConstraints(newMods);
        // PENDING: constraint checking depending on the lock type 
        if ((newMods & (Modifier.STATIC | Modifier.STRICT | Modifier.FINAL |
            Modifier.ABSTRACT | Modifier.SYNCHRONIZED)) > 0) {
            throw new SourceException("Invalid constructor modifiers : " +  // NOI18N
                Modifier.toString(newMods));
        }
    }

    public String toString() {
        return "ConstructorElementImpl[" + getName().getSourceName() + ", " + // NOI18N
            getParameters().length + " args]"; // NOI18N
    }
    
    protected Element cloneSelf() {
        ConstructorElement clone = new ConstructorElement();
        copyCallableProperties(clone);
        return clone;
    }
}