/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.bridge;

// import java.beans.PropertyChangeEvent;
import java.util.*;

import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.TypeReference;

import org.openide.src.*;

class ConstructorsCollection extends ObjectsCollection {

    static final ConstructorElement[] EMPTY = new ConstructorElement[0];
    
    public ConstructorsCollection(FeaturesCollection members) {
        super (members);
    }

    public RefObject createFeature(RefObject parent, Element elem) {
        Constructor res = members.createConstructor ((ConstructorElement) elem);
        // res.setDeclaringClass ((JavaClass) parent);
        return res;
    }
    
    public Element [] getEmptyArray () {
        return EMPTY;
    }
    
    public String getPropertyName () {
        return ElementProperties.PROP_CONSTRUCTORS;
    }
    
    public boolean isOfType (RefObject feature) {
        return feature instanceof Constructor;
    }
    
    public Element createElement (RefObject constr) {
        return (ConstructorElement) members.model.createConstructor (members.getParentClass (), (Constructor)constr).getElement ();
    }
    
    public ConstructorElement getConstructor(Type[] argtypes) {
        members.repository.beginTrans(false);
        try {
            if (isValid()) {
                if (argtypes == null)
                    argtypes = NO_TYPES;
                List args = members.typesToDescriptors (argtypes);
                Constructor constr = members.javaClass.getConstructor (args, false);
                return constr == null ? null : (ConstructorElement)cachedElement (constr);
            } else {
                return null;
            }
        } finally {
            members.repository.endTrans();
        }
    }
    
    public ConstructorElement [] getConstructors() {
        return (ConstructorElement []) getElements ();
    }
    
    // [PENDING] this code nearly duplicates MethodsCollection.matches () ...    
    public boolean matches (Element elem, RefObject f) {
        Constructor method = (Constructor) f;
        ConstructorElement methodElem = (ConstructorElement) elem;
        
        // check parameters
        List params = method.getParameters();
        MethodParameter [] params2 = methodElem.getParameters ();
        if (params.size () != params2.length)
            return false;
        Iterator iter = params.iterator ();
        for (int x = 0; x < params2.length; x++) {
            TypeReference typeRef = ((Parameter) iter.next ()).getTypeName ();
            Type type2 = params2 [x].getType ();
            if (typeRef == null) {
                if (type2 != null)
                    return false;
            } else if (!members.parentImpl.typeReferenceToType (typeRef).equals (type2))
                return false;
        }
        
        return true;
    }
    
    public int getPositionalValue () {
        return ObjectsCollection.POS_VAL_CONSTRUCTOR;
    }
    
}
