/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.bridge;

import org.openide.src.*;

/**
 * Dump insertion strategy, that inserts after all elemnets with the given type.
 * Element types are ordered -- a future extension would be to allow specify the order
 * of element types.
 *
 * @author  sdedic
 * @version 
 */
class DefaultInsertStrategy implements Positioner {
    public Element[] findInsertPositions(Element container, Element[] els, Acceptor posAcceptor) {
        Element[] siblings;
        
        if (container instanceof SourceElement) {
            siblings = ((SourceElement)container).getClasses();
        } else {
            siblings = findElements((ClassElement)container, els[0]);
        }
        Element[] refs = new Element[els.length];
        Element ref;
        if (siblings == null || siblings.length == 0) {
            ref = Positioner.FIRST;
        } else {
            ref = siblings[siblings.length - 1];
        }
        ref = findSuitablePos(container, ref, posAcceptor);
        refs[0] = ref;
        for (int i = 1; i < refs.length; i++) {
            refs[i] = els[i - 1];
        }
        return refs;
    }
    
    private Element findSuitablePos(Element container, Element ref, Acceptor acc) {
        if (acc.canInsertAfter(ref))
            return ref;
        ElementOrder o = (ElementOrder)container.getCookie(ElementOrder.class);
        Element[] children = o.getElements();
        int prefPos = 0;
        int i;
        
        for (i = 0; i < children.length; i++) {
            if (ref == children[i]) {
                prefPos = i;
                break;
            }
        }
        int after = prefPos + 1;
        int before = prefPos - 1;

        while (before >= -1 || after < children.length) {
            if (after < children.length) {
                if (acc.canInsertAfter(children[after]))
                    return children[after];
                after++;
            }
            if (before >= 0) {
                if (acc.canInsertAfter(children[before])) {
                    return children[before];
                }
                before--;
            } else if (before == -1) {
                if (acc.canInsertAfter(FIRST)) 
                    return FIRST;
                before--;
            }
        }
        return null;
    }

    private Element[] findElements(ClassElement container, Element selector) {
        if (selector instanceof FieldElement) {
            return getFirstNonEmpty(container, 0);
        } else if (selector instanceof ClassElement) {
            return getFirstNonEmpty(container, 4);
        } else if (selector instanceof MethodElement) {
            return getFirstNonEmpty(container, 3);
        } else if (selector instanceof ConstructorElement) {
            return getFirstNonEmpty(container, 2);
        } else if (selector instanceof InitializerElement) {
            return getFirstNonEmpty(container, 1);
        }
        return null;
    }
        
    private Element[] getFirstNonEmpty(ClassElement container, int startPos) {
        Element[] items;
        
        if (startPos > 3) {
            items = container.getClasses();
            if (items != null && items.length > 0)
                return items;
        }
        if (startPos > 2) {
            items = container.getMethods();
            if (items != null && items.length > 0)
                return items;
        }
        if (startPos > 1) {
            items = container.getConstructors();
            if (items != null && items.length > 0)
                return items;
        }
        if (startPos > 0) {
            items = container.getInitializers();
            if (items != null && items.length > 0)
                return items;
        }
        items = container.getFields();
        if (items != null && items.length > 0)
            return items;
        return null;
    }
}
