/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.bridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;

import javax.swing.undo.UndoableEdit;

import org.openide.src.SourceException;

/**
 *
 * @author  sdedic
 * @version 
 */
interface ElementEvents {
    /** Adds a PropertyChangeEvent to be fired. The event is not necessarily fired
     * immediately, but may be queued and fired after a lock on the element/model is
     * released. The method may throw IllegalArgumentException, if the event source
     * reported in the event does not match the return value of {@link #getSource}
     * @param evt the event to be fired
     */
    public void addPropertyChange(PropertyChangeEvent evt);
    
    /** Fires a property change event to Vetoable listeners. If a listener cancels
     * the ongoing change, its response is wrapped into a SourceException object which
     * is thrown from the method. The method may throw IllegalArgumentException, if the event source
     * reported in the event does not match the return value of {@link #getSource}
     * @param evt the event to be fired
     */
    public void fireVetoableChange(PropertyChangeEvent evt) throws SourceException;
    
    /** Adds another UndoableEdit. Generally there should be an edit for each partial
     * operation on any data structure. Those edits are grouped such that edits generated
     * during one particular change operation are always undone as a group.
     * @param edit the edit that should be queued in the undo queue
    public void addUndoableEdit(UndoableEdit edit);
     */
    
    /** Returns the event source for events that should be fired on this interface.
     * @return object representing the event source.
     */
    public Object getEventSource();
    
    /** Returns the implementation of the element.
     */
    public ElementImpl getElementImpl();
}
