/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.bridge;

import java.beans.*;
import java.util.*;
import java.lang.ref.WeakReference;

import org.openide.nodes.Node;
import org.openide.src.*;

import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.RefBaseObject;

import org.netbeans.api.mdr.events.*;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.IsOfType;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.ArrayReference;
import org.netbeans.jmi.javamodel.EnumConstant;
import org.netbeans.jmi.javamodel.PrimitiveType;

final class FieldElementImpl extends MemberElementImpl implements FieldElement.Impl {

    private static final long serialVersionUID = 6799964214013985830L;
    
    private ElementImpl.ElementListener fieldListener;
        
    FieldElementImpl(DefaultLangModel model, Field fieldElement) {                        
        super(model, fieldElement);
        javadoc = new JavaDocImpl.Field(null, this);
    }        
            
    public void connectListener () {
        FieldListener fieldListener = new FieldListener (this);
        fieldListener.connect ();
    }
    
    protected void createFromModel(Element el) throws SourceException {
        super.createFromModel(el);
        FieldElement f = (FieldElement)el;
        setType(f.getType());
        setInitValue(f.getInitValue());
        setJavaDocText(f.getJavaDoc().getRawText(), true);
    }

    /** Type of the variable.
    * @return the type
    */
    public Type getType() {
        repository.beginTrans(false);
        try {
            if (javaElement.isValid()) {
                setClassPath();
                if (javaElement instanceof EnumConstant) {
                    return descrToType(((Field) javaElement).getType());
                }
                javaElement.refImmediateComposite(); // ensure that javaElement is valid (getTypeName does not throw InvalidObjectException, see issue #50364)
                org.netbeans.jmi.javamodel.Type t = ((Field)javaElement).getType();
                if (t instanceof PrimitiveType) {
                    return descrToType(t);
                }
                return typeReferenceToType (((Field) javaElement).getTypeName ());
            } else {
                if (fieldListener != null)
                    return ((FieldListener)fieldListener).type;
                else
                    return Type.VOID;
            }
        } finally {
            repository.endTrans(false);
        }
    }
    
    public JavaDoc.Field getJavaDoc() {
        updateJavadoc();
        return (JavaDoc.Field)javadoc;
    }
    
    public Object readResolve() {
        return null;
    }
    
    /** Setter for type of the variable.
    * @param type the variable type
    */
    public void setType(Type type) throws SourceException {
        checkWritable(true);
        checkDocument();
        boolean failed = true;
        repository.beginTrans (true);
        try {
            if (javaElement.isValid()) {
                setClassPath();
                Type oldType = getType ();
                PropertyChangeEvent evt;
                type = resolveType(type);
                if (compareSourceTypes(oldType, type)) {
                    failed = false;
                    return;
                }
                evt = new PropertyChangeEvent(getElement(), PROP_TYPE, oldType, type);
                checkVetoablePropertyChange(evt);
                if (type.isPrimitive()) {
                    ((Field) javaElement).setType(typeToDescr(type));
                } else {
                    ((Field) javaElement).setTypeName(typeToTypeReference(type));
                }
                failed = false;
            } else {
                failed = false;
                throwIsInvalid ();
            }
        } finally {
            repository.endTrans (failed);
        }
    }

    /** Getter for the initial value.
    * @return initial value for the variable or empty string if it is not initialized
    */
    public String getInitValue() {
        repository.beginTrans(false);
        try {
            if (javaElement.isValid()) {
                setClassPath();
                return ((Field)javaElement).getInitialValueText();
            } else {
                return null;
            }
        } finally {
            repository.endTrans(false);
        }
    }

    /** Setter for the initial value.
    * @param value initial value for the variable
    */
    public void setInitValue(String newInitValue) throws SourceException {
        checkWritable(false);
        checkDocument();
        String oldInitValue=getInitValue();
        boolean failed = true;
        repository.beginTrans (true);
        try {
            if (javaElement.isValid()) {
                PropertyChangeEvent evt;
                setClassPath();
                if ((newInitValue == oldInitValue) || 
                    ((newInitValue != null) && newInitValue.equals(oldInitValue))) {
                    return;
                }
                evt = new PropertyChangeEvent(getElement(), PROP_INIT_VALUE, oldInitValue, newInitValue);
                // no constraings on the Initializer... only check vetoable listeners.
                checkVetoablePropertyChange(evt);

                ((Field)javaElement).setInitialValueText(newInitValue);
                failed = false;
            } else {
                failed = false;
                throwIsInvalid ();
            }
        } finally {
            repository.endTrans (failed);
        }
    }

    public void fireTypeChange (Type oldType, Type newType) {
        oldType = resolveType (oldType);
        newType = resolveType (newType);
        if (compareSourceTypes(oldType, newType))
            return;
        
        PropertyChangeEvent evt = new PropertyChangeEvent(getElement(), PROP_TYPE, oldType, newType);
        fireOwnPropertyChange(evt);
        
        FieldElement oldField = (FieldElement) cloneSelf ();
        try {
            FieldElement.Impl impl = (FieldElement.Impl) oldField.getCookie (Element.Impl.class);
            impl.setType (oldType);
        } catch (SourceException e) {
            e.printStackTrace ();
        }
        notifyConnectionChange (oldField);
    }

    public void fireInitValueChange (String oldVal, String newVal) {
        PropertyChangeEvent evt = new PropertyChangeEvent(getElement(), PROP_INIT_VALUE, oldVal, newVal);
        fireOwnPropertyChange(evt);
    }
    
    // Utility methods.
    //////////////////////////////////////////////////////////////////////////////////
    
    protected Element createWrapperElement() {
        return null;
    }
    
    public String toString() {
        return "FieldElementImpl[" + getName().getSourceName() + "]"; // NOI18N
    }
    
    protected Element cloneSelf() {
        return (Element)((FieldElement)getElement()).clone();
    }
    
    // ..........................................................................

    static class FieldListener extends MemberElementImpl.MemberElementListener implements MDRChangeListener {

        // [PENDING] this code duplicates MethodListener
        
        private Type type;
        
        FieldListener (FieldElementImpl impl) {
            super (impl);
        }
        
        public void connect () {
            if (REGISTER_LISTENER) {
                super.connect ();
                TypeReference typeRef = ((Field) javaElement).getTypeName();
                if (typeRef != null) {
                    type = ((FieldElementImpl) getImpl ()).typeReferenceToType (typeRef);
                } else {
                    type = null;
                }
            }
        }
        
        public void doChange(MDRChangeEvent event) {
            super.doChange (event);

            if (event instanceof AttributeEvent) {
                AttributeEvent attrEvent = (AttributeEvent) event;
                String attrName = attrEvent.getAttributeName();
                Object source = event.getSource();
                if (attrName.equals("typeName")) { // NOI18N
                    Type oldType = type;
                    TypeReference typeRef = (TypeReference) attrEvent.getNewElement();
                    if (typeRef != null) {
                        type = ((FieldElementImpl) getImpl()).typeReferenceToType(typeRef);                    
                    } else {
                        type = null;
                    }
                    ((FieldElementImpl) impl).fireTypeChange (oldType, type);
                } else if (attrName.equals("initialValueText")) { // NOI18N
                    ((FieldElementImpl) impl).fireInitValueChange ((String)attrEvent.getOldElement(), (String)attrEvent.getNewElement());
                }
            }
        }
    
    }
    
}
