/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.bridge;

import java.util.Iterator;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.Field;
import org.openide.src.*;

class FieldsCollection extends ObjectsCollection {

    static final FieldElement[] EMPTY = new FieldElement[0];
        
    public FieldsCollection(FeaturesCollection members) {
        super(members);
    }

    public RefObject createFeature(RefObject parent, Element elem) {
        Field res = members.createField ((FieldElement) elem);
        // res.setDeclaringClass ((JavaClass) parent);
        return res;
    }

    public Element [] getEmptyArray () {
        return EMPTY;
    }
    
    public String getPropertyName () {
        return ElementProperties.PROP_FIELDS;
    }
    
    public boolean isOfType (RefObject feature) {
        return feature instanceof Field;
    }
    
    public Element createElement (RefObject field) {        
        return members.model.createField (members.getParentClass (), (Field)field).getElement ();        
    }
    
    public FieldElement getField(Identifier name) {
        members.repository.beginTrans(false);
        try {
            if (isValid()) {
                String fieldName = name.getName();
                Field field = members.javaClass.getField (fieldName, false);
                return field == null ? null : (FieldElement)cachedElement (field);
            } else {
                return null;
            }
        } finally {
            members.repository.endTrans();
        }
    }
    
    public FieldElement [] getFields() {
        return (FieldElement []) getElements ();
    }
        
    public boolean matches (Element elem, RefObject f) {
        Field field = (Field) f;
        FieldElement fieldElem = (FieldElement) elem;        
        return field.getName ().equals (fieldElem.getName ().getName ());
    }
    
    public int getPositionalValue () {
        return ObjectsCollection.POS_VAL_FIELD;
    }
    
}
