/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.bridge;

import java.beans.PropertyChangeEvent;

import org.openide.src.*;

import org.netbeans.api.mdr.events.*;
import org.netbeans.jmi.javamodel.JavaPackage;

public class ImportImpl extends ElementImpl implements ImportElement.Impl {

    SourceElementImpl   sourceImpl;
    
    private ElementImpl.ElementListener importListener;
    
    private static final long serialVersionUID = -3319955190266278185L;
        
    ImportImpl(DefaultLangModel model, org.netbeans.jmi.javamodel.Import imp) {
        super(model, imp);        
    }
    
    public void connectListener () {
        importListener = new ImportListener (this);
        importListener.connect ();
    }
    
    protected void createFromModel(Element model) throws SourceException {        
        ImportElement i = (ImportElement)model;        
        setImport(i.getImport());
    }

    public void setParent(ElementImpl impl) {
        sourceImpl = (SourceElementImpl)impl;
    }
    
    public Import getImport() {
        repository.beginTrans(false);
        try {
            if (javaElement.isValid()) {
                setClassPath();
                org.netbeans.jmi.javamodel.Import importStatement = (org.netbeans.jmi.javamodel.Import) javaElement;
                String impName = importStatement.getName ();
                if (impName == null) // [PENDING]
                    impName = "";
                Identifier id = Identifier.create (impName);
                return new Import (id, importStatement.getImportedNamespace() instanceof JavaPackage ? Import.PACKAGE : Import.CLASS); // NOI18N
            } else {
                return null;
            }
        } finally {
            repository.endTrans(false);
        }
    }
    
    public SourceElementImpl findSource() {
        return sourceImpl;
    }
    
    public void setImport(Import imp) throws SourceException {
        checkWritable(false);
        checkDocument();
        org.netbeans.jmi.javamodel.Import importStatement = (org.netbeans.jmi.javamodel.Import) javaElement;
        boolean failed = true;
        repository.beginTrans (true);
        try {
            if (javaElement.isValid()) {
                setClassPath();
                boolean isNamed = !importStatement.getName ().endsWith(".*"); // NOI18N
                String impName = importStatement.getName ();
                if ((isNamed == imp.isClass ()) &&
                    (imp.getIdentifier().getSourceName().equals(impName))) {
                    failed = false;
                    return;
                }
                Import old = new Import (Identifier.create (impName),
                    isNamed ? Import.CLASS : Import.PACKAGE);
                PropertyChangeEvent evt = new PropertyChangeEvent(
                    getElement(), "import", old, imp); // NOI18N
                checkVetoablePropertyChange(evt);

                // sourceImpl.imports.importsChanged(); // [PENDING] should this be called ??
                failed = false;
            } else {
                failed = false;
                throwIsInvalid ();
            }
        } finally {
            repository.endTrans (failed);
        }
    }

    protected Element cloneSelf() {
        ImportElement.MemoryImpl impl = new ImportElement.MemoryImpl();
        try {
            impl.setImport(getImport());
        } catch (SourceException e) {
        }
        return new ImportElement(impl, null);
    }
    
    public void fireImportChange (Import oldValue, Import newValue) {
        if (oldValue.equals (newValue))
            return;
        PropertyChangeEvent evt = new PropertyChangeEvent(
                getElement(), "import", oldValue, newValue); // NOI18N        
        fireOwnPropertyChange(evt);
        
        ImportElement old = (ImportElement) cloneSelf ();
        try {
            old.setImport (oldValue);
        } catch (SourceException e) {
            e.printStackTrace ();
        }
        notifyConnectionChange (old);
    }
    
    public Object readResolve() {
        return null;
    }
    
    public Object writeReplace() {
        return null;
    }
    
    protected boolean parentValid() {
        return sourceImpl != null && sourceImpl.isValid();
    }
    
    protected void checkWritable(boolean unsafeOp) throws SourceException {
        if (sourceImpl != null) {
            sourceImpl.checkWritable(unsafeOp);
        }
    }
    
    // ..........................................................................
    
    static class ImportListener extends ElementImpl.ElementListener {
        
        Import value;
        
        ImportListener (ImportImpl impl) {
            super (impl);
            value = impl.getImport ();
        }                
    
        public void doChange (MDRChangeEvent event) {
            super.doChange (event);
            if ((source == javaElement) && (event instanceof AttributeEvent)) {                                                
                AttributeEvent attrEvent = (AttributeEvent) event;
                String attrName = attrEvent.getAttributeName ();
                if (attrName.equals ("name")) { // NOI18N
                    String name = (String) attrEvent.getNewElement ();
                    if (name == null) {
                        name = "";
                    }
                    boolean isClass = true;
                    if (name.endsWith(".*")) { // NOI18N
                        isClass = false;
                        name = name.substring (0, name.length() - 2);
                    }
                    Import old = value;                    
                    value = new Import (Identifier.create (name), isClass);
                    ((ImportImpl) impl).fireImportChange (old, value);
                }
            }
        }
    }
    
}
