/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.bridge;

import java.util.*;

import org.openide.src.*;

import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefBaseObject;
import org.netbeans.api.mdr.events.*;

import org.netbeans.jmi.javamodel.Resource;

class ImportsCollection extends ObjectsCollection {

    static final ImportElement[] EMPTY = new ImportElement[0];
    
    private Resource resource;
    
    public ImportsCollection(FeaturesCollection members, Resource resource) {
        super (members);
        this.resource = resource;
    }

    public RefObject createFeature(RefObject parent, Element elem) {
        org.netbeans.jmi.javamodel.Import res = members.createImport ((ImportElement) elem);
        return res;
    }
    
    public Element [] getEmptyArray () {
        return EMPTY;
    }
    
    public String getPropertyName () {
        return ElementProperties.PROP_IMPORTS;
    }
    
    public boolean isOfType (RefObject feature) {
        boolean isStatic = false;
        members.repository.beginTrans(false);
        try {
            if (((org.netbeans.jmi.javamodel.Import) feature).isValid())
                isStatic = ((org.netbeans.jmi.javamodel.Import) feature).isStatic();
        } finally {
            members.repository.endTrans(false);
        }
        return (feature instanceof org.netbeans.jmi.javamodel.Import) && !isStatic;
    }        
    
    public boolean isClassMember () {
        return false;
    }
    
    public List getFeatures () {
        return resource.getImports ();        
    }
    
    public boolean isValid() {
        return resource.isValid();
    }
    
    public Element createElement (RefObject imp) {
        return (ImportElement) members.model.createImport ((SourceElement) members.parentImpl.getElement (), (org.netbeans.jmi.javamodel.Import)imp).getElement ();
    }
 
    public Import[] getImports() {
        ImportElement[] elems = (ImportElement[]) getElements ();
        Import[] res = new Import [elems.length];
        for (int x = 0; x < elems.length; x++) {
            res [x] = elems [x].getImport ();
        }
        return res;
    }
    
    protected void addMembers (Element[] items) throws SourceException {
        if (items.length == 0)
            return;
        
        members.repository.beginTrans (true);
        boolean failed = true;
        try {
            if (resource.isValid()) {
                members.parentImpl.setClassPath();
                List features = getFeatures ();
                ImportElement[] imps = new ImportElement[features.size()];
                Map posToImps = new HashMap ();
                Iterator iter = features.iterator();
                for (int x = 0; iter.hasNext(); x++) {
                    imps[x] = (ImportElement) cachedElement ((RefObject) iter.next());
                }

                for (int x = 0; x < items.length; x++) {
                    int pos = 0;
                    Import newImp = ((ImportElement) items[x]).getImport();
                    for (int y = 0; y < imps.length; y++) {
                        Import imp = ((ImportElement)imps[y]).getImport();
                        if(imp.getIdentifier().getFullName().compareTo(newImp.getIdentifier().getFullName() ) < 0 ) {
                            pos = y + 1;
                        }
                    }
                    Integer integer = new Integer(pos);
                    List list = (List) posToImps.get (integer);
                    if (list == null) {
                        list = new LinkedList();
                        posToImps.put (integer, list);
                    }
                    list.add (items[x]);
                }

                ListIterator listIter = features.listIterator();
                for (int x = 0; x <= imps.length; x++) {
                    List list = (List) posToImps.get (new Integer(x));
                    if (list != null) {
                        iter = list.iterator();
                        while (iter.hasNext()) {
                            listIter.add (createFeature (members.javaClass, (Element)iter.next()));
                        }
                    }
                    if (listIter.hasNext())
                        listIter.next();
                }            
                failed = false;
            } else {
                failed = false;
                members.parentImpl.throwIsInvalid ();
            }
        } finally {
            members.repository.endTrans (failed);
        }
    }
    
    protected void setMembers (Element[] items) throws SourceException {                
        members.repository.beginTrans (true);
        boolean failed = true;
        try {
            if (resource.isValid()) {
                members.parentImpl.setClassPath();
                List features = getFeatures ();
                features.clear ();
                for (int x = 0; x < items.length; x++) {
                    features.add (createFeature (members.javaClass, items[x]));
                }            
                failed = false;
            } else {
                failed = false;
                members.parentImpl.throwIsInvalid ();
            }
        } finally {
            members.repository.endTrans (failed);
        }
    }
    
    public void changeImports(Import[] defs, int operation) throws SourceException {
        ImportElement[] elems = new ImportElement [defs.length];
        for (int x = 0; x < defs.length; x++) {
            elems [x] = new ImportElement (
                new ImportElement.MemoryImpl (), 
                (SourceElement) members.parentImpl.getElement ()
            );
            elems [x].setImport (defs [x]);            
        }        
        changeMembers (elems, operation);
    }
    
    public boolean matches (Element elem, RefObject f) {
        org.netbeans.jmi.javamodel.Import imp = (org.netbeans.jmi.javamodel.Import) f;
        if (imp.isStatic())
            return false;
        Import srcImp = ((ImportElement) elem).getImport ();
        String name1 = imp.getName ();
        boolean isNamed1 = true;
        if (name1.endsWith("*")) { // NOI18N
            isNamed1 = false;
            name1 = name1.substring (0, name1.length() - 2);
        }
        String name2 = srcImp.getIdentifier ().getFullName ();
        if ((name1 == null) || (name2 == null))
            return false;
        return (isNamed1 == srcImp.isClass ()) && name1.equals (name2);
    }
    
    // ..........................................................................
    
    static class ImportsListener extends ObjectsCollection.FeaturesListener {

        ImportsListener (ElementImpl impl) {
            super (impl);
            fireMembers = false;
        }

        public void connect () {
            if (REGISTER_LISTENER) {
                ((MDRChangeSource) javaElement).addListener (this);
                features = new ArrayList ();
                features.addAll (((Resource) javaElement).getImports ());
            }
        }

        public ObjectsCollection getFeatureCollection (RefObject feature) {
            return ((SourceElementImpl) impl).imports;            
        }
        
        protected boolean isWatchedAttribute (AttributeEvent ev) {
            return ev.getAttributeName ().equals ("imports"); // NOI18N
        }
        
        public Element cachedElement (RefObject f) {
            return ((SourceElementImpl) impl).imports.cachedElement (f);
        }
        
    }

}
