/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.bridge;

// import java.beans.PropertyChangeEvent;
import java.util.*;
import java.lang.reflect.Modifier;

import javax.jmi.reflect.RefObject;

import org.netbeans.jmi.javamodel.Initializer;

import org.openide.src.*;

class InitializersCollection extends ObjectsCollection {
    
    static final InitializerElement[] EMPTY = new InitializerElement[0];
    
    public InitializersCollection(FeaturesCollection members) {
        super (members);        
    }        

    public RefObject createFeature(RefObject parent, Element elem) {
        Initializer res = members.createInitializer ((InitializerElement) elem);
        // res.setDeclaringClass ((JavaClass) parent);
        return res;
    }
    
    public Element [] getEmptyArray () {
        return EMPTY;
    }

    public String getPropertyName () {
        return ElementProperties.PROP_INITIALIZERS;
    }
    
    public boolean isOfType (RefObject feature) {
        return feature instanceof Initializer;
    }
    
    public Element createElement (RefObject initializer) {
        return (InitializerElement) members.model.createInitializer(members.getParentClass (), (Initializer)initializer).getElement ();
    }
    
    public InitializerElement [] getInitializers () {
        return (InitializerElement []) getElements ();
    }

    public boolean matches (Element elem, RefObject f) {
        Initializer init = (Initializer) f;
        InitializerElement initElem = (InitializerElement) elem;
        return ((init.getModifiers () & Modifier.STATIC) > 0) == initElem.isStatic ();
    }
    
    public int getPositionalValue () {
        return ObjectsCollection.POS_VAL_INITIALIZER;
    }
}
