/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.bridge;

import javax.jmi.reflect.InvalidObjectException;

import java.beans.*;
import java.util.*;
import javax.jmi.reflect.RefBaseObject;
import org.openide.src.*;

import org.netbeans.api.mdr.events.*;

import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.IsOfType;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.ArrayReference;
import org.netbeans.jmi.javamodel.PrimitiveType;

/**
 * The class implements properties specific to a method.
 *
 * @author  Svatopluk Dedic, Petr Hamernik, Jaroslav Tulach
 * @version 0.1
 * @since 24/11/2000
 */
class MethodElementImpl extends CallableImpl implements MethodElement.Impl {

    private ElementImpl.ElementListener methodListener;
    
    private static final long serialVersionUID = 8831749368310053231L;
    
    // Construction
    ///////////////////////////////////////////////////////////////////////////////////

    MethodElementImpl(DefaultLangModel model, Method method) {
        super(model, method);
    }        
    
    public void connectListener () {
        methodListener = new MethodListener (this);
        methodListener.connect ();
    }
    
    protected void createFromModel(Element el) throws SourceException {
        super.createFromModel(el);
        MethodElement m = (MethodElement)el;
        setReturn(m.getReturn());
    }
    
    // Getters
    ///////////////////////////////////////////////////////////////////////////////
    
    /**
     * Retrieves the return type of the method.
     * @return the return type description.
     */
    public Type getReturn() {
        repository.beginTrans(false);
        try {
            if (javaElement.isValid()) {
                setClassPath();
                javaElement.refImmediateComposite(); // check if javaElement is valid
                org.netbeans.jmi.javamodel.Type t = ((Method)javaElement).getType();
                if (t instanceof PrimitiveType) {
                    return descrToType(t);
                }
                return typeReferenceToType (((Method)javaElement).getTypeName ());
            } else {
                return Type.VOID;
            }
        } finally {
            repository.endTrans(false);
        }
    }
    
    // Setters
    ///////////////////////////////////////////////////////////////////////////////

    /**
     * Sets the return type.
     */
    public void setReturn(Type newType) throws SourceException {                
        checkWritable(true);
        checkDocument();
        boolean failed = true;
        repository.beginTrans (true);
        try {
            if (javaElement.isValid()) {
                setClassPath();
                Type oldType = getReturn ();
                newType = resolveType(newType);
                if (compareSourceTypes(oldType, newType)) {
                    failed = false;
                    return;
                }            
                PropertyChangeEvent evt = new PropertyChangeEvent(getElement(), PROP_RETURN, oldType, newType);

                checkReturnTypeConstraints(newType);
                checkVetoablePropertyChange(evt);

                if (newType.isPrimitive()) {
                    ((Method) javaElement).setType(typeToDescr(newType));
                } else {
                    ((Method) javaElement).setTypeName(typeToTypeReference(newType));
                }
                failed = false;
            } else {
                failed = false;
                throwIsInvalid ();
            }
        } finally {
            repository.endTrans (failed);
        }
    }
    
    public void fireReturnChange (Type oldType, Type newType) {
        oldType = resolveType (oldType);
        newType = resolveType (newType);
        if (compareSourceTypes(oldType, newType))
            return;
        
        PropertyChangeEvent evt = new PropertyChangeEvent(getElement(), PROP_RETURN, oldType, newType);
        fireOwnPropertyChange(evt);
        
        MethodElement elem = (MethodElement) cloneSelf ();                            
        try {
            MethodElement.Impl impl = (MethodElement.Impl) elem.getCookie (Element.Impl.class);
            impl.setReturn (oldType);
        } catch (SourceException e) {
            e.printStackTrace ();
        }
        notifyConnectionChange (elem);
    }
    
    // Utility and helper methods.
    ///////////////////////////////////////////////////////////////////////////////
    protected final Element createWrapperElement() {
        return new MethodElement(this, getDeclaringClass());
    }
    
    protected void checkReturnTypeConstraints(Type t) throws SourceException {
        // no checking, no constraings on the rettype.
    }

    // Serialization support
    ///////////////////////////////////////////////////////////////////////////////
    public Object readResolve() {
        return null;
    }
    
    public String toString() {
        return "MethodElementImpl[" + getName().getSourceName() + ", " + // NOI18N
            getParameters().length + " args]"; // NOI18N
    }
    
    protected Element cloneSelf() {
        MethodElement clone = new MethodElement();
        copyCallableProperties(clone);
        try {
            clone.setReturn(getReturn());
        } catch (SourceException ex) {
        }
        return clone;
    }
    
    // ..........................................................................

    static class MethodListener extends CallableImpl.CallableListener implements MDRChangeListener {

        private Type type;
        
        MethodListener (MethodElementImpl impl) {
            super (impl);
        }
        
        public void connect () {
            if (REGISTER_LISTENER) {
                super.connect ();
                TypeReference typeRef = ((Method) javaElement).getTypeName();
                if (typeRef != null) {
                    type = ((MethodElementImpl) getImpl ()).typeReferenceToType (typeRef);                    
                } else {
                    type = null;
                }
            }
        }
        
        public void doChange(MDRChangeEvent event) {
            super.doChange (event);
            if (event instanceof AttributeEvent) {
                AttributeEvent attrEvent = (AttributeEvent) event;
                String attrName = attrEvent.getAttributeName();
                Object source = event.getSource();
                if (attrName.equals("typeName")) { // NOI18N
                    Type oldType = type;
                    TypeReference typeRef = (TypeReference) attrEvent.getNewElement();
                    if (typeRef != null) {
                        type = ((MethodElementImpl) getImpl()).typeReferenceToType(typeRef);                    
                    } else {
                        type = null;
                    }
                    ((MethodElementImpl) impl).fireReturnChange(oldType, type);
                }
            }
        }

    }

}
