/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.bridge;

import org.openide.src.*;

/**
 * Provides "null" binding that silently discards all editing operations. This can
 * be used as an implementation of an advanced in-memory representation, or for temporary
 * objects that are not backed up in any document/stream, or for testing purposes.
 *
 * @author  Svatopluk Dedic
 * @version 0.1
 */
public class NullBinding implements Binding.Class, Binding.Method, Binding.Field, 
    Binding.Initializer, Binding.Source, Binding.Import {
    public NullBinding() {
    }

    public void changeBody(String bodyString) throws SourceException {
    }
    public void changeClassType(boolean properClass) throws SourceException {
    }
    public void changeExceptions(Identifier[] exceptions) throws SourceException {
    }
    public void changeInitializer(String newInitializer) throws SourceException {
    }
    public void changeInterfaces(Identifier[] replaceWith) throws SourceException {
    }
    public void changeModifiers(int newMods) throws SourceException {
    }
    public void changeName(String newName) throws SourceException {
    }
    public void changeName(Identifier name) throws SourceException {
    }
    public void changeParameters(MethodParameter[] params) throws SourceException {
    }
    public void changeReturnType(Type type) throws SourceException {
    }
    public void changeStatic(boolean enable) throws SourceException {
    }
    public void changeSuperclass(Identifier id) throws SourceException {
    }
    public void changeType(Type newType) throws SourceException {
    }
    public void create() throws SourceException, IllegalStateException {
    }
    public void makeAbstract() throws SourceException {
    }
    public void createBody(String body) throws SourceException {
    }
    public void replaceBody(String body) throws SourceException {
    }
    public void copyBody(String body) {
    }
    public String getBodyContent() throws SourceException {
        return null;
    }
    public void remove() throws SourceException, IllegalStateException {
    }
    public void updateFrom(Binding other) {
    }
    
    public void insert(Binding one, Binding two) {
    }
    
    public void replace(Binding one, Binding two) {
    }
    
    public void reorder(java.util.Map targetmap) {
    }
    
    public boolean canInsertAfter(Binding b) {
        return true;
    }
    
    public Binding.Container getClassSection() {
        return this;
    }
    
    public Binding.Container getImportsSection() {
        return this;
    }
    
    public void changePackage(Identifier id) throws SourceException {
    }

    public void changeImport(org.openide.src.Import i) throws SourceException {
    }
    
    public void changeJavaDoc(JavaDoc impl) throws SourceException {
    }
    
    public void changeMembers(MultiPropertyChangeEvent evt) throws SourceException {
    }
    
}
