/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.codegen;

import org.openide.src.*;

import org.netbeans.modules.java.bridge.Binding;

/**
 *
 * @author  sdedic
 * @version 
 */
class Member extends ElementBinding implements Binding.Member {
    /** Creates new Member */
    public Member(MemberElement me, SourceText s) {
        super(me, s);
    }
    
    protected Element cloneElement() {
        try {
            return (MemberElement)((MemberElement)getElement()).clone();
        } catch (CloneNotSupportedException ex) {
            throw new InternalError("Cannot clone element."); // NOI18N
        }
    }

    /**
     * Requests change of member's modifiers.
     */
    public void changeModifiers(int newMods) throws SourceException {
        if (!source.isGeneratorEnabled())
            return;
        
        MemberElement el = (MemberElement)cloneElement();
        el.setModifiers(newMods);
        regenerateHeader(el);
    }
    
    /**
     * Requests a change of member's name.
     */
    public void changeName(Identifier name) throws SourceException {
        if (!source.isGeneratorEnabled())
            return;
        
        MemberElement el = (MemberElement)cloneElement();
        el.setName(name);
        regenerateHeader(el);
    }
    
    /**
     * Updates the storage binding object from an external SourceText.
     */
    public void updateFrom(Binding other) {
    }
}
