/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.codegen;

import org.openide.text.PositionRef;
import org.openide.text.PositionBounds;
/**
 * Helps with sorting elements according to their positions.
 *
 * @author  Svatopluk Dedic <mailto:sdedic@netbeans.org>
 * @version 0.1
 */
class PositionComparator implements java.util.Comparator {
    public int compare(java.lang.Object p1, java.lang.Object p2) {
        if (p1 instanceof Integer) {
            return comparePosToBinding((Integer)p1, (ElementBinding)p2);
        } else if (p2 instanceof PositionRef) {
            return -comparePosToBinding((Integer)p2, (ElementBinding)p1);
        }
        ElementBinding b1 = (ElementBinding)p1;
        ElementBinding b2 = (ElementBinding)p2;
        
        return b1.wholeBounds.getBegin().getOffset() -
               b2.wholeBounds.getBegin().getOffset();
    }
    
    private int comparePosToBinding(Integer iPos, ElementBinding b) {
        int off = iPos.intValue();
        PositionBounds w = b.wholeBounds;
        if (w.getBegin().getOffset() <= off &&
            w.getEnd().getOffset() > off)
            return 0;
        return off - w.getBegin().getOffset();
    }
    
    public boolean equals(java.lang.Object p1) {
        return (p1 instanceof PositionComparator);
    }
}
