/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.codegen;

import javax.swing.text.Position;
import javax.swing.text.StyledDocument;

import org.openide.src.*;
import org.openide.text.*;

import org.netbeans.modules.java.bridge.Binding;

/**
 *
 * @author  svata
 * @version 
 */
class SourceB extends ElementBinding implements Binding.Source {
    /** Bounds for the package statement, or null if the statement is not present.
     */
    PositionBounds      packageBounds;
    
    /** Support for containment of classes.
     */
    ContainerSupport    classContainer;
    
    /** Support for containment of interfaces.
     */
    ContainerSupport    importContainer;
    
    public SourceB(SourceElement src, SourceText s) {
        super(src, s);
        classContainer = new ContainerSupport(s, this);
        importContainer = new ContainerSupport(s, this);
        importContainer.separateMembers = false;
    }
    
    protected Element cloneElement() {
        return null;
    }
    
    public void changePackage(final Identifier id) throws SourceException {
        if (!source.isGeneratorEnabled())
            return;
        
        source.runAtomic(getElement(), new ExceptionRunnable() {
            public void run() throws Exception {
                PositionBounds bounds;
                
                if (packageBounds == null)
                    bounds = findPackageBounds();
                else
                    bounds = packageBounds;
                if (id == null) {
                    CodeGenerator.clearBounds(bounds, true);
                    packageBounds = null;
                } else {
                    StringBuffer sb = new StringBuffer();
                    
                    sb.append("package "); // NOI18N
                    sb.append(id.getSourceName());
                    sb.append(";"); // NOI18N
                    CodeGenerator.fillTextBounds(bounds, sb.toString());
                    if (packageBounds == null) {
                        // add a newline:
                        StyledDocument d = source.getDocument();
                        d.insertString(bounds.getEnd().getOffset(),
                            "\n", null); // NOI18N
                    }
                    packageBounds = bounds;
                }
            }
        });
    }
    
    public Binding.Container getImportsSection() {
        return importContainer;
    }
    
    public Binding.Container getClassSection() {
        return classContainer;
    }

    public ElementBinding findBindingAt(int pos) {
        return classContainer.findBindingAt(pos);
    }

    /**
     * The operation does nothing, because the source cannot be removed ;-)
     */
    public void remove() throws SourceException {
    }
    
    public void updateBounds(int kind, PositionBounds b) {
        super.updateBounds(kind, b);
        // update package bounds - if there is some package declaration.
        if (kind == BOUNDS_PACKAGE) {
            packageBounds = b;
        }
    }
    
    /**
     * This method should return PositionBounds of the maximum possible
     * extent for a container.
     */
    PositionBounds findContainerBounds(TextBinding.Container cont) {
        int begin = -1, end = -1;
        
        if (cont == importContainer) {
            if (packageBounds != null) {
                begin = packageBounds.getEnd().getOffset();
            } else if (importContainer == null || importContainer.isEmpty()) {
                // beginning of the text.
                begin = 0;
            } else {
                begin = importContainer.getFirstPosition().getOffset();
            }
            if (classContainer == null || classContainer.isEmpty()) {
                end = -1;
            } else {
                end = classContainer.getFirstPosition().getOffset();
            }
        } else if (cont == classContainer) {
            if (importContainer == null || importContainer.isEmpty()) {
                if (packageBounds == null) {
                    begin = 0;
                } else {
                    begin = packageBounds.getEnd().getOffset();
                }
            } else {
                begin = importContainer.getLastPosition().getOffset();
            }
        } else 
            throw new IllegalArgumentException(cont.toString());

        if (end == -1) {
            StyledDocument doc = source.getEditorSupport().getDocument();
            if (doc == null)
                end = begin;
            else 
                end = doc.getLength();
        }

        PositionBounds b =  new PositionBounds(
            source.createPos(begin, Position.Bias.Forward),
            source.createPos(end, Position.Bias.Backward));
        return b;
    }
    
    private PositionBounds findPackageBounds() throws SourceException {
        PositionBounds bounds = null;
        
        if (importContainer != null && !importContainer.isEmpty())
            bounds = importContainer.getContainerBounds();
        
        if (bounds == null && !classContainer.isEmpty())
            bounds = classContainer.getContainerBounds();
        
        if (bounds != null)
            return CodeGenerator.createNewLineBounds(bounds.getBegin(), 
                CodeGenerator.BOUNDS_PACKAGE);
        
        return CodeGenerator.createNewLineBounds(
            source.createPos(0, Position.Bias.Forward),
            CodeGenerator.BOUNDS_PACKAGE);
    }
    
    public void updatePackageBounds(PositionBounds b) {
        this.packageBounds = b;
    }
}
