/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.parser;

import org.openide.nodes.Node;
import org.openide.src.*;

import java.util.WeakHashMap;

import org.netbeans.modules.java.bridge.BindingFactory;
import org.netbeans.modules.java.bridge.LangModel;
import org.netbeans.modules.java.bridge.WrapperFactory;
import org.netbeans.modules.java.codegen.DocumentBinding;

/**
 * Standard stupid & simple implementation of the language model environment.
 *
 * @author  sdedic
 * @version 
 */
public class LangEnvImpl implements LangModel.Env {
    WeakHashMap     cookieMap;
    DocumentBinding binding;
    WrapperFactory  wrapper;
    LangModel model;
    
    public LangEnvImpl(DocumentBinding docBinding) {
        this.binding = docBinding;
        this.wrapper = DefaultWrapper.getInstance();
        cookieMap = new WeakHashMap(57);
    }
    
    public void setModel(LangModel model) {
        this.model = model;
    }

    public BindingFactory getBindingFactory() {
        return binding;
    }
    
    public WrapperFactory getWrapperFactory() {
        return wrapper;
    }

    /**
     * Currently no-op implementation.
     */
    public void complete(Element scope, int informationKind) {
    }
    
    /** The environment is called to resolve type name according to the context it
     * is used in. The current implementation will return all primitives and
     * array of primitives unchanged, but will delegate resolution of class names
     * to the {@link #resolveTypeIdent}. If the resolved type identifier is different
     * than the original, it reconstructs the type and returns it.
    */
    public Type resolveType(Element context, Type original) {
        if (original.isPrimitive())
            return original;
        Type t = original;
        int depth = 0;
        while (t.isArray()) {
            t = t.getElementType();
            depth++;
        }
        if (t.isPrimitive())
            return original;
        
        Identifier id = t.getTypeIdentifier();
        Identifier resolved = resolveTypeIdent(context, id);
        if (resolved == id)
            return original;
        
        // build up the type again.
        t = Type.createClass(resolved);
        while (depth > 0) {
            t = Type.createArray(t);
            depth--;
        }
        return t;
    }
    
    /**
     * This is called to resolve/transform a name of a type for this context.
     * Assume the context will only be ClassElement or SourceElement. This implementation
     * does not attempt to resolve identifiers, it only marks them as 
     * {@link org.openide.src.Identifier#NOT_YET_RESOLVED} to distinguish them from
     * resolved ones.
    */
    public Identifier resolveTypeIdent(Element context, Identifier original) {
        if (model.isSameContext(context, original))
            return original;
        return model.createLocalIdentifier(context, original.getFullName(), 
            original.getSourceName(), Identifier.NOT_YET_RESOLVED);
    }
    
    public Node.Cookie findCookie(Element el, Class requested) {
        return null;
    }
}
