/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * ProcessorObjectRequest.java
 *
 * Created on March 20, 2001, 1:40 PM
 */

package org.netbeans.modules.java.parser;

import org.openide.text.CloneableEditorSupport;

/**
 *
 * @author  thurka
 * @version 
 */
public interface ProcessorObjectRequest {

    /** Notifies the request object that the engine has resheduled this request.
     * Internal request data should be cleared.
    */
    public void notifyReschedule();
    
    /**
     * Notifies the request that the source text has been changed. This causes
     * cancellation of the request in some cases.
    */
    public void sourceChanged();

    /**
     * Notifies the request that the model has been changed. This causes
     * cancellation of the request in some cases.
    */
    public void modelChanged();
    
    public void setEnvironment(JavaParser.Env env);
    
    public void setEditorSupport(CloneableEditorSupport editor);
}

