/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.ui.editors;

import java.beans.*;
import java.util.*;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import org.openide.cookies.SourceCookie;

import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;

import org.openide.loaders.DataFilter;
import org.openide.loaders.DataObject;

import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.nodes.FilterNode;

import org.openide.src.*;

import org.netbeans.modules.java.tools.MultiDataContainer;
import org.netbeans.modules.java.ui.nodes.PackageNode;

/**
 * This panel helps to choose a Class representation from the given
 * classpath.
 *
 * @author Svatopluk Dedic (sdedic@netbeans.org)
 */
public class ClassChooserPanel extends javax.swing.JPanel 
    implements ExplorerManager.Provider, PropertyChangeListener, 
    VetoableChangeListener, DataFilter, EnhancedCustomPropertyEditor {

    /**
     */
    private MultiDataContainer  rootContainer;
    
    /**
     */
    private ExplorerManager     manager;
    
    /**
     * Root of the package/class selection hierarchy.
     */
    private Node                packageRootNode;
    
    /**
     * Object used to synchronize the explorer with the input line component.
     */
    TreePathWalker              walker;
    
    TypeIdentPE                 propertyEditor;
    
    /** Creates new form TypeSelector */
    public ClassChooserPanel(TypeIdentPE propertyEditor, Collection classPathRoots) {
        this.propertyEditor = propertyEditor;
        
        initComponents();
        rootContainer = new MultiDataContainer(classPathRoots, this);
    }
    
    public void addNotify() {
        super.addNotify();

        Node n;
        n = new PackageNode("", rootContainer);
        packageRootNode = new FilterNode(n, new Ch(n));
        getExplorerManager().setRootContext(packageRootNode);

        // initialize the tree walker
        walker = new TreePathWalker(getExplorerManager());
        walker.setTextComponent(className);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jLabel1 = new javax.swing.JLabel();
        className = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        jTextField1 = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        beanTreeView1 = new org.openide.explorer.view.BeanTreeView();
        
        setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;
        
        jLabel1.setText("Name:"); // NOI18N
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.insets = new java.awt.Insets(0, 0, 8, 0);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(jLabel1, gridBagConstraints1);
        
        className.setText("jTextField2"); // NOI18N
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new java.awt.Insets(0, 8, 8, 0);
        gridBagConstraints1.weightx = 1.0;
        add(className, gridBagConstraints1);
        
        jLabel2.setText("Full name:"); // NOI18N
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.insets = new java.awt.Insets(0, 0, 8, 0);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(jLabel2, gridBagConstraints1);
        
        jTextField1.setEditable(false);
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new java.awt.Insets(0, 8, 8, 0);
        gridBagConstraints1.weightx = 0.75;
        add(jTextField1, gridBagConstraints1);
        
        jLabel3.setText("Browse:"); // NOI18N
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(jLabel3, gridBagConstraints1);
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        add(beanTreeView1, gridBagConstraints1);
        
    }//GEN-END:initComponents

    private void classNameKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_classNameKeyTyped
    }//GEN-LAST:event_classNameKeyTyped

    /** Get the explorer manager.
     * @return the manager
     */
    public ExplorerManager getExplorerManager() {
        if (manager == null)
            manager = ExplorerManager.find(this);
        return manager;
    }    


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JTextField className;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JTextField jTextField1;
    private javax.swing.JLabel jLabel3;
    private org.openide.explorer.view.BeanTreeView beanTreeView1;
    // End of variables declaration//GEN-END:variables

    private class Ch extends FilterNode.Children {
        Ch(Node original) {
            super(original);
        }
        
        protected Node[] createNodes(Object key) {
            Node origNode = (Node)key;
            ClassElement c = (ClassElement)origNode.getCookie(ClassElement.class);
            if (c != null &&
                !acceptsClass(c))
                return new Node[0];
            else {
                Children ch = origNode.getChildren() == Children.LEAF ? Children.LEAF :
                    new Ch(origNode);
                return new Node[] {
                    new FilterNode(origNode, ch)
                };
            }
        }
    }
    
    /**
     * Determines whether to display a particular class' node or not.
     */
    private boolean acceptsClass(ClassElement c) {
        return c.isClassOrInterface();
    }
    
    public boolean acceptDataObject(DataObject obj) {
        return obj.getCookie(SourceCookie.class) != null ||
               obj.getCookie(DataObject.Container.class) != null;
    }
    
    /** Get the customized property value.
     * @return the property value
     * @exception InvalidStateException when the custom property editor does not contain a valid property value
     *           (and thus it should not be set)
     */
    public Object getPropertyValue() throws IllegalStateException {
        Node[] sel = getExplorerManager().getSelectedNodes();
        if (sel.length != 1)
            throw new IllegalStateException("Exactly one node has to be selected"); // NOI18N
        Node n = sel[0];
        ClassElement el = (ClassElement)n.getCookie(ClassElement.class);
        if (el == null)
            throw new IllegalStateException("Class node is not selected"); // NOI18N
        return el.getName();
    }
    
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (evt.getSource() == getExplorerManager() &&
            ExplorerManager.PROP_SELECTED_NODES.equals(evt.getPropertyName())) {
            Node[] ns = (Node[])evt.getNewValue();
            if (ns.length > 1)
                throw new PropertyVetoException("Multiple selection is not allowed.", evt); // NOI18N
        }
    }
    
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == getExplorerManager() &&
            ExplorerManager.PROP_SELECTED_NODES.equals(evt.getPropertyName())) {
            Node[] ns = (Node[])evt.getNewValue();
            boolean enable = ns.length == 1;
            ClassElement el = null;
            
            if (enable) {
                el = (ClassElement)ns[0].getCookie(ClassElement.class);
                enable &= el != null;
            }
            if (enable) {
                try {
                    propertyEditor.checkInputConstraints(null, el);
                } catch (IllegalArgumentException ex) {
                    enable = false;
                }
            }
            propertyEditor.enableOK(enable);
        }
    }
}
