/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.ui.nodes;

import org.openide.nodes.Node;
import org.openide.src.*;
import org.netbeans.jmi.javamodel.*;

/**
 * Bridges {@link org.openide.src.nodes.ElementNodeFactory} to {@link SourceNodeFactory}
 */
final class BridgeElement2Source implements SourceNodeFactory {
    
    private final ExElementNodeFactory delegate;
    
    public BridgeElement2Source(ExElementNodeFactory factory) {
        this.delegate = factory;
    }

    public Node createConstructorNode(Constructor element) {
        ConstructorElement constructor = BridgeUtils.getElement(element);
        return delegate.createConstructorNode(constructor);
    }

    public Node createMethodNode(Method element) {
        MethodElement method = BridgeUtils.getElement(element);
        return delegate.createMethodNode(method);
    }

    public Node createFieldNode(Field element) {
        FieldElement field = BridgeUtils.getElement(element);
        return delegate.createFieldNode(field);
    }

    public Node createInitializerNode(Initializer element) {
        InitializerElement init = BridgeUtils.getElement(element);
        return delegate.createInitializerNode(init);
    }

    public Node createClassNode(JavaClass element) {
        ClassElement ce = null;
        if (element != null) {
            ce = BridgeUtils.getElement(element);
        }
        return delegate.createClassNode(ce);
    }

    public Node createEnumNode(JavaEnum element) {
        return delegate.createEnumNode(element);
    }

    public Node createEnumConstantNode(EnumConstant element) {
        return delegate.createEnumConstantNode(element);
    }

    public Node createAnnotationTypeNode(AnnotationType element) {
        return delegate.createAnnotationTypeNode(element);
    }

    public Node createAnnotationTypeMethodNode(Attribute element) {
        return delegate.createAnnotationTypeMethodNode(element);
    }

    public Node createWaitNode() {
        return delegate.createWaitNode();
    }

    public Node createErrorNode() {
        return delegate.createErrorNode();
    }
    
}
