/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.ui.nodes;

import org.openide.src.*;
import org.openide.nodes.Node;
import org.netbeans.jmi.javamodel.*;

/**
 * Bridges {@link SourceNodeFactory} to {@link org.openide.src.nodes.ElementNodeFactory}
 */
final class BridgeSource2Element implements ExElementNodeFactory {
    
    private final SourceNodeFactory delegate;
    
    public BridgeSource2Element(SourceNodeFactory delegate) {
        this.delegate = delegate;
    }

    public Node createConstructorNode(ConstructorElement element) {
        Constructor constr = (Constructor) BridgeUtils.getJavaObject(element);
        return delegate.createConstructorNode(constr);
    }

    public Node createMethodNode(MethodElement element) {
        Method method = (Method) BridgeUtils.getJavaObject(element);
        return delegate.createMethodNode(method);
    }

    public Node createFieldNode(FieldElement element) {
        Field field = (Field) BridgeUtils.getJavaObject(element);
        return delegate.createFieldNode(field);
    }

    public Node createInitializerNode(InitializerElement element) {
        Initializer init = (Initializer) BridgeUtils.getJavaObject(element);
        return delegate.createInitializerNode(init);
    }

    public Node createClassNode(ClassElement element) {
        JavaClass jo = null;
        if (element != null) {
            jo = (JavaClass) BridgeUtils.getJavaObject(element);
        }
        return delegate.createClassNode(jo);
    }

    public Node createWaitNode() {
        return delegate.createWaitNode();
    }

    public Node createErrorNode() {
        return delegate.createErrorNode();
    }

    public Node createEnumNode(JavaEnum element) {
        return delegate.createEnumNode(element);
    }

    public Node createEnumConstantNode(EnumConstant element) {
        return delegate.createEnumConstantNode(element);
    }

    public Node createAnnotationTypeNode(AnnotationType element) {
        return delegate.createAnnotationTypeNode(element);
    }

    public Node createAnnotationTypeMethodNode(Attribute element) {
        return delegate.createAnnotationTypeMethodNode(element);
    }
}
