/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.ui.nodes;

import org.openide.src.nodes.ElementNodeFactory;
import org.openide.nodes.Node;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.EnumConstant;
import org.netbeans.jmi.javamodel.Attribute;

/**
 * extended {@link ElementNodeFactory} interface to support jdk1.5 features
 */
public interface ExElementNodeFactory extends ElementNodeFactory {
    /**
     * @see SourceNodeFactory#createEnumNode
     */ 
    public Node createEnumNode(JavaEnum element);
    /**
     * @see SourceNodeFactory#createEnumConstantNode
     */ 
    public Node createEnumConstantNode(EnumConstant element);
    /**
     * @see SourceNodeFactory#createAnnotationTypeNode
     */ 
    public Node createAnnotationTypeNode(AnnotationType element);
    /**
     * @see SourceNodeFactory#createAnnotationTypeMethodNode
     */ 
    public Node createAnnotationTypeMethodNode(Attribute element);
}
