/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.ui.nodes.elements;

import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Resource;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.ErrorManager;

import javax.jmi.reflect.JmiException;
import javax.swing.*;
import java.awt.*;
import java.lang.reflect.Modifier;

/** Customizer for AnnotationType
 *
 * @author Jan Pokorsky
 */
public class AnnotationTypeCustomizer extends javax.swing.JPanel {
    /** The edited class */
    private final JavaClass element;
    /**
     * class where the customized annotation type should be added; can be null
     */ 
    private final JavaClass jclass;
    /** java resource where the annotation type should be added; can be null */
    private final Resource resource;
    
    private boolean isOK = true;
    
    /** Create new AnnotationTypeCustomizer component for inner annotation types
    * @param jclass class where the customized inner class or inner interface should be added
    * @param element The annotation type to be customized
    */
    public AnnotationTypeCustomizer(JavaClass jclass, AnnotationType element) {
        this(null, jclass, element);
    }
    
    /** Create new ClassCustomizer component for top-level annotation types
    * @param resource java resource where the customized annotation type should be added
    * @param element The annotation type to be customized
    */
    public AnnotationTypeCustomizer(Resource resource, AnnotationType element) {
        this(resource, null, element);
    }
    
    private AnnotationTypeCustomizer(Resource resource, JavaClass jclass, AnnotationType element) {
        this.resource = resource;
        this.jclass = jclass;
        this.element = element;
        
//        modifiersPP = SourceEditSupport.createModifiersPanel(element);
//        me = (ModifierEditor) modifiersPP.getProperty().getPropertyEditor();
        
        initComponents();
        
        nameTextField.setText(element.getSimpleName());
        
        int mask = Modifier.PUBLIC | Modifier.ABSTRACT;
        if (resource == null) { // inner class
            mask |= Modifier.PUBLIC | Modifier.PROTECTED | Modifier.PRIVATE | Modifier.STATIC;
        }
        accessPanel.add(SourceEditSupport.createAccessModifiersPanel(this.element, mask), BorderLayout.CENTER);
        modifiersPanel.add(SourceEditSupport.createOtherModifiersPanel(this.element, mask), BorderLayout.CENTER);
        
        HelpCtx.setHelpIDString (this, "java.annotationType.customizer"); // NOI18N
        
        nameLabel.setDisplayedMnemonic(NbBundle.getMessage(AnnotationTypeCustomizer.class, "CTL_Name_Mnemonic").charAt(0)); // NOI18N
        nameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AnnotationTypeCustomizer.class, "ACSN_AnnotationTypeNameTextField")); // NOI18N
        nameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AnnotationTypeCustomizer.class, "ACSD_AnnotationTypeNameTextField")); // NOI18N
        
        accessLabel.setDisplayedMnemonic(NbBundle.getMessage(AnnotationTypeCustomizer.class, "CTL_AccessRights_Mnemonic").charAt(0)); // NOI18N
        this.getAccessibleContext().setAccessibleDescription("ACSD_AnnotationTypeCustomizer"); // NOI18N
    }
    
    public void addNotify() {
        super.addNotify();

        // select the name
        int l = nameTextField.getText().length();
        nameTextField.setCaretPosition(0);
        nameTextField.moveCaretPosition(l);
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                nameTextField.requestFocus();
            }
        });
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        nameLabel = new javax.swing.JLabel();
        nameTextField = new javax.swing.JTextField();
        accessLabel = new javax.swing.JLabel();
        accessPanel = new javax.swing.JPanel();
        modifiersLabel = new javax.swing.JLabel();
        modifiersPanel = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(5, 5, 5, 5)));
        nameLabel.setLabelFor(nameTextField);
        org.openide.awt.Mnemonics.setLocalizedText(nameLabel, org.openide.util.NbBundle.getMessage(AnnotationTypeCustomizer.class, "CTL_Name"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        add(nameLabel, gridBagConstraints);

        nameTextField.setColumns(25);
        nameTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                nameTextFieldFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 8, 0, 0);
        add(nameTextField, gridBagConstraints);

        accessLabel.setLabelFor(accessPanel);
        org.openide.awt.Mnemonics.setLocalizedText(accessLabel, org.openide.util.NbBundle.getMessage(AnnotationTypeCustomizer.class, "CTL_AccessRights"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 0, 0, 0);
        add(accessLabel, gridBagConstraints);

        accessPanel.setLayout(new java.awt.BorderLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 0, 0);
        add(accessPanel, gridBagConstraints);

        modifiersLabel.setLabelFor(modifiersPanel);
        org.openide.awt.Mnemonics.setLocalizedText(modifiersLabel, org.openide.util.NbBundle.getMessage(AnnotationTypeCustomizer.class, "CTL_Modifiers"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 0, 0, 0);
        add(modifiersLabel, gridBagConstraints);

        modifiersPanel.setLayout(new java.awt.BorderLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 0, 8);
        add(modifiersPanel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.weighty = 1.0;
        add(jPanel1, gridBagConstraints);

    }
    // </editor-fold>//GEN-END:initComponents

    private void nameTextFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_nameTextFieldFocusLost
        if (evt != null && evt.isTemporary())
            return;

        String newName = nameTextField.getText().trim();
        String oldName = element.getSimpleName();
        boolean ok = false;
        
        if (!Utilities.isJavaIdentifier(newName)) {
            IllegalArgumentException x = new IllegalArgumentException("Invalid name: " + newName); // NOI18N
            ErrorManager.getDefault().annotate(
                x, ErrorManager.USER, null, 
                NbBundle.getMessage(AnnotationTypeCustomizer.class, "MSG_Not_Valid_Identifier"), // NOI18N
                null, null);
            ErrorManager.getDefault().notify (x);
        } else if (oldName.equals(newName)) {
            return; // nothing to change
        } else if (this.resource == null && jclass.getInnerClass(newName, true) != null) {
            IllegalArgumentException x = new IllegalArgumentException("Invalid name: " + newName); // NOI18N
            ErrorManager.getDefault().annotate(
                x, ErrorManager.USER, null, 
                NbBundle.getMessage(AnnotationTypeCustomizer.class, "MSG_Not_Valid_Identifier"), // NOI18N
                null, null);
            ErrorManager.getDefault().notify (x);
        } else if (this.jclass == null && SourceEditSupport.findTopLevelClass(this.resource, newName) != null) {
            IllegalArgumentException x = new IllegalArgumentException("Invalid name: " + newName); // NOI18N
            ErrorManager.getDefault().annotate(
                x, ErrorManager.USER, null, 
                NbBundle.getMessage(AnnotationTypeCustomizer.class, "MSG_Not_Valid_Identifier"), // NOI18N
                null, null);
            ErrorManager.getDefault().notify (x);
        } else {
            try {
                element.setSimpleName(newName);
                ok = true;
            } catch (JmiException e) {
                ErrorManager.getDefault().notify(e);
            }
        }
        isOK = ok;
        if (!ok) {
            nameTextField.setText(oldName);
        }
    }//GEN-LAST:event_nameTextFieldFocusLost
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel accessLabel;
    private javax.swing.JPanel accessPanel;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JLabel modifiersLabel;
    private javax.swing.JPanel modifiersPanel;
    private javax.swing.JLabel nameLabel;
    private javax.swing.JTextField nameTextField;
    // End of variables declaration//GEN-END:variables
    
    public boolean isOK() {
        nameTextFieldFocusLost(null);
        return isOK;
    }
    
}
