/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.ui.nodes.elements;

import java.awt.BorderLayout;
import java.lang.reflect.Modifier;

import javax.swing.*;
import javax.jmi.reflect.JmiException;

import org.openide.*;
import org.openide.util.Utilities;
import org.openide.util.NbBundle;
import org.openide.util.HelpCtx;

import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.java.ui.nodes.editors.TypeEditor;
import org.netbeans.jmi.javamodel.*;

/** Customizer for Attribute
 *
 * @author Jan Pokorsky, Petr Hamernik
 */
public final class AnnotationTypeMethodCustomizer extends JPanel {
    /** Predefined types in the type combo;
     *  duplicate of {@link org.netbeans.modules.java.ui.nodes.editors.TypeEditor#RVALUE_TYPES}
     */ 
    private static final String[] COMMON_TYPES = TypeEditor.ANNTYPE_VALUE_TYPES;

    /**
     * class where the customized method should be added 
     */ 
    private final AnnotationType jclass;
    
    /** Edited method */
    private final Attribute element;

    private boolean isOK = true;

    /** Create new MethodCustomizer component
    * @param jclass class where the customized method should be added
    * @param element The method or constructor to be customized
    */
    public AnnotationTypeMethodCustomizer(AnnotationType jclass, Attribute element) {
        this.jclass = jclass;
        this.element = element;

        initComponents ();

        // modifiers
        int mask = Modifier.PUBLIC | Modifier.ABSTRACT;
        accessPanel.add(SourceEditSupport.createAccessModifiersPanel(element, mask), BorderLayout.CENTER);
        modifierPanel.add(SourceEditSupport.createOtherModifiersPanel(element, mask), BorderLayout.CENTER);

        // name
        nameTextField.setText(element.getName());
        returnCombo.setSelectedItem(element.getType().getName());
        defValueTextField.setText(element.getDefaultValueText());

        HelpCtx.setHelpIDString (this, "java.annotationTypeMethod.customizer"); // NOI18N
        //mnemonics
        jLabel1.setDisplayedMnemonic(getString("CTL_Name_Mnemonic").charAt(0)); // NOI18N
        jLabel2.setDisplayedMnemonic(getString("CTL_MethodType_Mnemonic").charAt(0));  // NOI18N
        jLabel3.setDisplayedMnemonic(getString("CTL_DefaultValue_Mnemonic").charAt(0));  // NOI18N
       
        initAccessibility();
    }
    
    public void addNotify() {
        super.addNotify();
        
        int len = nameTextField.getText().length();
        nameTextField.setCaretPosition(0);
        nameTextField.moveCaretPosition(len);
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                nameTextField.requestFocus();
            }
        });
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        nameTextField = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        returnCombo = new javax.swing.JComboBox(COMMON_TYPES);
        jLabel3 = new javax.swing.JLabel();
        defValueTextField = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        accessPanel = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        modifierPanel = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(6, 6, 6, 6)));
        jLabel1.setLabelFor(nameTextField);
        jLabel1.setText(org.openide.util.NbBundle.getMessage(AnnotationTypeMethodCustomizer.class, "CTL_Name"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        add(jLabel1, gridBagConstraints);

        nameTextField.setColumns(25);
        nameTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                nameTextFieldFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 8, 0, 0);
        add(nameTextField, gridBagConstraints);

        jLabel2.setLabelFor(returnCombo);
        jLabel2.setText(org.openide.util.NbBundle.getMessage(AnnotationTypeMethodCustomizer.class, "CTL_ReturnType"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 0, 0, 0);
        add(jLabel2, gridBagConstraints);

        returnCombo.setEditable(true);
        returnCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                returnComboActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 0, 0);
        add(returnCombo, gridBagConstraints);

        jLabel3.setLabelFor(defValueTextField);
        jLabel3.setText(org.openide.util.NbBundle.getMessage(AnnotationTypeMethodCustomizer.class, "CTL_DefaultValue"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 0, 0, 0);
        add(jLabel3, gridBagConstraints);

        defValueTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                defValueTextFieldFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 0, 0);
        add(defValueTextField, gridBagConstraints);

        jLabel4.setLabelFor(accessPanel);
        jLabel4.setText(org.openide.util.NbBundle.getMessage(AnnotationTypeMethodCustomizer.class, "CTL_AccessRights"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 0, 0, 0);
        add(jLabel4, gridBagConstraints);

        accessPanel.setLayout(new java.awt.BorderLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 0, 0);
        add(accessPanel, gridBagConstraints);

        jLabel5.setLabelFor(modifierPanel);
        jLabel5.setText(org.openide.util.NbBundle.getMessage(AnnotationTypeMethodCustomizer.class, "CTL_Modifiers"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 0, 0, 0);
        add(jLabel5, gridBagConstraints);

        modifierPanel.setLayout(new java.awt.BorderLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 0, 0);
        add(modifierPanel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.weighty = 1.0;
        add(jPanel1, gridBagConstraints);

    }
    // </editor-fold>//GEN-END:initComponents

    private void defValueTextFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_defValueTextFieldFocusLost
        if (evt != null && (evt.isTemporary() || !this.isAncestorOf(evt.getOppositeComponent())))
            return;
        
        String newName = defValueTextField.getText().trim();
        newName = newName.length() > 0? newName: null;
        String oldName = element.getDefaultValueText();
        boolean ok = false;
        
        try {
            if (newName != null && newName.equals(oldName) || newName == oldName) {
                return; // nothing to change
            } else {
                this.element.setDefaultValueText(newName);
                ok = true;
            }
        } catch (JmiException e) {
            ErrorManager.getDefault().notify(e);
        }
        isOK = ok;
        if (!ok) {
            oldName = oldName == null? "": oldName; // NOI18N
            defValueTextField.setText(oldName);
        }
    }//GEN-LAST:event_defValueTextFieldFocusLost

    private void returnComboActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_returnComboActionPerformed
        Object selItem = returnCombo.getSelectedItem();
        if (selItem == null)
           return;
        
        String selItemTxt = selItem.toString().trim();
        Type oldValue = element.getType();
        boolean ok = false;
        
        try {
            Type newValue = getJModel().getType().resolve(selItemTxt);
            if (oldValue.equals(newValue)) {
                return;
            } else if (!TypeEditor.isValidTypeSyntax(selItemTxt)) {
                notifyUserWarning("MSG_Not_Valid_Type", "invalid type"); // NOI18N
            } else if (!TypeEditor.isValidTypeOfAnnTypeMethod(newValue)) {
                notifyUserWarning("MSG_Not_Valid_Type", "invalid type"); // NOI18N
            } else {
                element.setType(newValue);
                ok = true;
            }
        } catch (JmiException e) {
            ErrorManager.getDefault().notify(e);
        }
        isOK = ok;
        if (!ok)
            returnCombo.setSelectedItem(ElementFormat.elementName(oldValue));
    }//GEN-LAST:event_returnComboActionPerformed
    
    private void nameTextFieldFocusLost (java.awt.event.FocusEvent evt) {//GEN-FIRST:event_nameTextFieldFocusLost
        if (evt != null && (evt.isTemporary() || !this.isAncestorOf(evt.getOppositeComponent())))
            return;
        
        String newName = nameTextField.getText().trim();
        String oldName = element.getName();
        boolean ok = false;
        
        try {
            if (!Utilities.isJavaIdentifier(newName)) {
                notifyUserWarning("MSG_Not_Valid_Type", "invalid type"); // NOI18N
            } else if (oldName.equals(newName)) {
                return; // nothing to change
            } else if (SourceEditSupport.findAttribute(this.jclass, newName) != null) {
                notifyUserWarning("MSG_Used_Identifier", newName, "invalid name"); // NOI18N
            } else {
                this.element.setName(newName);
                ok = true;
            }
        } catch (JmiException e) {
            ErrorManager.getDefault().notify(e);
        }
        isOK = ok;
        if (!ok) {
            nameTextField.setText(oldName);
        }
    }//GEN-LAST:event_nameTextFieldFocusLost
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel accessPanel;
    private javax.swing.JTextField defValueTextField;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel modifierPanel;
    private javax.swing.JTextField nameTextField;
    private javax.swing.JComboBox returnCombo;
    // End of variables declaration//GEN-END:variables

    private void initAccessibility() {
        nameTextField.getAccessibleContext().setAccessibleName(getString("ACS_MethodNameTextField")); // NOI18N
        nameTextField.getAccessibleContext().setAccessibleDescription(getString("ACS_MethodNameTextField")); // NOI18N
        defValueTextField.getAccessibleContext().setAccessibleName(getString("ACSN_DefaultValue")); // NOI18N
        defValueTextField.getAccessibleContext().setAccessibleDescription(getString("ACSD_DefaultValue")); // NOI18N
        this.getAccessibleContext().setAccessibleDescription(getString("ACSD_AnnotationTypeMethodCustomizer")); // NOI18N
    }                       
    
    public boolean isOK() {
        nameTextFieldFocusLost(null);
        if (isOK) {
            returnComboActionPerformed(null);
        }
        if (isOK) {
            defValueTextFieldFocusLost(null);
        }
        return isOK;
    }
    
    private JavaModelPackage getJModel() {
        return JavaMetamodel.getManager().getJavaExtent(this.jclass);
    }
    
    private static String getString(String key) {
        return NbBundle.getMessage(AnnotationTypeMethodCustomizer.class, key);
    }
    
    private static void notifyUserWarning(String bundleKey, String msg) {
        IllegalArgumentException e = new IllegalArgumentException(msg); // NOI18N
        ErrorManager.getDefault().annotate(
            e, ErrorManager.USER, null, 
            getString(bundleKey),
            null, null);
        ErrorManager.getDefault().notify(e);
    }
    
    private static void notifyUserWarning(String bundleKey, String param, String msg) {
        IllegalArgumentException e = new IllegalArgumentException(msg);
        ErrorManager.getDefault().annotate(
            e, ErrorManager.USER, null, 
            NbBundle.getMessage(AnnotationTypeMethodCustomizer.class, bundleKey, param),
            null, null);
        ErrorManager.getDefault().notify(e);
    }
}
