/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.ui.nodes.elements;

import org.netbeans.jmi.javamodel.Attribute;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.java.ui.nodes.editors.TypeEditor;
import org.openide.nodes.Children;
import org.openide.nodes.Sheet;
import org.openide.nodes.Node;
import org.openide.src.ElementProperties;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

import javax.jmi.reflect.JmiException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.HashMap;

/** Node for a annotation type method.
 * @see org.netbeans.jmi.javamodel.Attribute
 * @author Jan Pokorsky
 */
public final class AnnotationTypeMethodNode extends ElementNode {
    
    private static final Map mapAttributeName;
    
    static {
        mapAttributeName = new HashMap();
        mapAttributeName.put(PROP_MODIFIERS, PROP_MODIFIERS);
        mapAttributeName.put(ElementProperties.PROP_NAME, ElementProperties.PROP_NAME);
        mapAttributeName.put("typeName", PROP_RETURN); // NOI18N
        mapAttributeName.put("defaultValueText", PROP_DEFAULT_VALUE); // NOI18N
    }
    
    /** Create a new method node.
    * @param element method element to represent
    * @param writeable <code>true</code> to be writable
    */
    public AnnotationTypeMethodNode(Attribute element, boolean writeable) {
        super(element, Children.LEAF, writeable);
        setElementFormat0(getElementFormatProperty());
        superSetName(element.getName());
    }

    protected String resolveIconBase() {
        return IconResolver.getIconBaseForAttribute(getMethod());
    }

    protected ElementFormat getElementFormatProperty() {
        return getSourceOptions().getAnnTypeMethodElementFormat();
    }

    /* This method resolve the appropriate hint format for the type
    * of the element. It defines the short description.
    */
    protected ElementFormat getHintElementFormat() {
        return getSourceOptions().getAnnTypeMethodElementLongFormat();
    }

    protected Map getAttributeNameMap() {
        return mapAttributeName;
    }

    /* Creates property set for this node */
    protected Sheet createSheet () {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = sheet.get(Sheet.PROPERTIES);
        ps.put(createModifiersProperty(writeable));
        ps.put(createNameProperty(getMethod()));
        ps.put(createReturnProperty(writeable));
        ps.put(createDefaultValueProperty(writeable));
        return sheet;
    }

    /** Create a property for the method default value.
    * @param canW <code>false</code> to force property to be read-only
    * @return the property
    */
    protected Node.Property createDefaultValueProperty(boolean canW) {
        return new ElementNode.ElementProp(PROP_DEFAULT_VALUE, String.class, canW) {

            public Object getValue () {
                String val = getMethod().getDefaultValueText(); 
                return val != null? val: ""; // NOI18N
            }
            
            /** Sets the value */
            public void setValue(final Object val) throws IllegalArgumentException,
                   IllegalAccessException, InvocationTargetException {
               
                super.setValue(val);
                if (!(val instanceof String)) throw new IllegalArgumentException();
                
                boolean fail = true;
                try {
                    JavaMetamodel.getDefaultRepository().beginTrans(true);
                    try {
                        getMethod().setDefaultValueText((String) val);
                        fail = false;
                    } finally {
                        JavaMetamodel.getDefaultRepository().endTrans(fail);
                    }
                } catch (JmiException e) {
                    IllegalArgumentException iae = new IllegalArgumentException();
                    iae.initCause(e);
                    ErrorManager.getDefault().annotate(iae, ErrorManager.USER, null,
                            NbBundle.getMessage(AnnotationTypeMethodNode.class, "MSG_InvalidDefaultVal"), null, null); // NOI18N
                    throw iae;
                }
            }
        };
    }

    /** Create a property for the method return value.
    * @param canW <code>false</code> to force property to be read-only
    * @return the property
    */
    private Node.Property createReturnProperty(boolean canW) {
        Node.Property np = createTypeProperty(PROP_RETURN, getMethod(), canW);
        np.setValue(TypeEditor.ANN_TYPE_EDITOR, Boolean.TRUE);
        return np;
    }
    
    private Attribute getMethod() {
        return (Attribute) this.element;
    }
}
