/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.ui.nodes.elements;

import org.openide.nodes.Children;
import org.openide.nodes.Sheet;
import org.openide.util.datatransfer.NewType;
import org.openide.src.ElementProperties;
import org.netbeans.jmi.javamodel.AnnotationType;

import java.util.Map;
import java.util.HashMap;

/**
 * Node representing an annotation type
 * @see org.netbeans.jmi.javamodel.AnnotationType
 */
public final class AnnotationTypeNode extends ElementNode {

    private static final Map mapAttributeName;
    
    static {
        mapAttributeName = new HashMap();
        mapAttributeName.put(PROP_MODIFIERS, PROP_MODIFIERS);
        mapAttributeName.put(ElementProperties.PROP_NAME, ElementProperties.PROP_NAME);
    }
    
    public AnnotationTypeNode(AnnotationType element, Children children, boolean writeable) {
        super(element, children, writeable);
        setElementFormat0(getElementFormatProperty());
    }

    protected String resolveIconBase() {
        return IconStrings.ANNOTATION_TYPE;
    }

    protected ElementFormat getElementFormatProperty() {
        return getSourceOptions().getAnnTypeElementFormat();
    }

    protected ElementFormat getHintElementFormat() {
        return getSourceOptions().getAnnTypeElementLongFormat();
    }

    protected Map getAttributeNameMap() {
        return mapAttributeName;
    }

    public NewType[] getNewTypes() {
        if (writeable) {
            return SourceEditSupport.createInterfaceNewTypes(getAnnotationType());
        } else {
            return super.getNewTypes();
        }
    }

    protected Sheet createSheet() {
        Sheet s = Sheet.createDefault();
        Sheet.Set ps = s.get(Sheet.PROPERTIES);
        ps.put(createModifiersProperty(writeable));
        ps.put(createNameProperty(getAnnotationType()));
        return s;
    }

    private AnnotationType getAnnotationType() {
        return (AnnotationType) this.element;
    }
}
