/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.ui.nodes.elements;

import org.openide.nodes.Children;
import org.openide.nodes.Sheet;
import org.openide.src.ElementProperties;
import org.netbeans.jmi.javamodel.EnumConstant;

import java.util.Map;
import java.util.HashMap;

/**
 * Node representing an enumeration constant
 * @see org.netbeans.jmi.javamodel.EnumConstant
 */
public final class EnumConstantNode extends ElementNode {

    private static final Map mapAttributeName;
    
    static {
        mapAttributeName = new HashMap(1);
        mapAttributeName.put(ElementProperties.PROP_NAME, ElementProperties.PROP_NAME);
    }
    
    public EnumConstantNode(EnumConstant element, Children children, boolean writeable) {
        super(element, children, writeable);
        setElementFormat0(getElementFormatProperty());
    }

    protected String resolveIconBase() {
        return IconStrings.ENUM_CONSTANT;
    }

    protected ElementFormat getHintElementFormat() {
        return getSourceOptions().getConstantElementLongFormat();
    }

    protected Map getAttributeNameMap() {
        return mapAttributeName;
    }

    protected Sheet createSheet() {
        Sheet s = Sheet.createDefault();
        Sheet.Set ps = s.get(Sheet.PROPERTIES);
        ps.put(createNameProperty(getEnumConstant()));
        return s;
    }
    
    private EnumConstant getEnumConstant() {
        return (EnumConstant) this.element;
    }

    protected String[] getIconAffectingProperties() {
        return new String[0];
    }

    protected ElementFormat getElementFormatProperty() {
        return getSourceOptions().getConstantElementFormat();
    }
}
