/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.ui.nodes.elements;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.HashMap;

import org.openide.nodes.*;
import org.openide.ErrorManager;
import org.openide.src.ElementProperties;
import org.openide.util.NbBundle;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;

import javax.jmi.reflect.JmiException;

/** Node representing a field (variable).
* @see org.netbeans.jmi.javamodel.Field
* @author Petr Hamernik, Jan Pokorsky
 * 
 * XXX help ids
*/
public final class FieldNode extends ElementNode {

    private static final Map mapAttributeName;
    
    static {
        mapAttributeName = new HashMap();
        mapAttributeName.put(PROP_MODIFIERS, PROP_MODIFIERS);
        mapAttributeName.put(ElementProperties.PROP_NAME, ElementProperties.PROP_NAME);
        mapAttributeName.put("typeName", PROP_TYPE); // NOI18N
        mapAttributeName.put("initialValueText", PROP_INIT_VALUE); // NOI18N
    }
    
    /** Create a new field node.
    * @param element field element to represent
    * @param writeable <code>true</code> to be writable
    */
    public FieldNode(Field element, boolean writeable) {
        super(element, Children.LEAF, writeable);
        setElementFormat0(getElementFormatProperty());
        superSetName(element.getName());
    }

    /* Resolve the current icon base.
    * @return icon base string.
    */
    protected String resolveIconBase() {
        return IconResolver.getIconBaseForField(getField());
    }

    protected ElementFormat getElementFormatProperty() {
        return getSourceOptions().getFieldElementFormat();
    }

    /* This method resolve the appropriate hint format for the type
    * of the element. It defines the short description.
    */
    protected ElementFormat getHintElementFormat() {
        return getSourceOptions().getFieldElementLongFormat();
    }

    protected Map getAttributeNameMap() {
        return mapAttributeName;
    }

    /* Creates property set for this node */
    protected Sheet createSheet () {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = sheet.get(Sheet.PROPERTIES);
        ps.put(createModifiersProperty(writeable));
        ps.put(createNameProperty(getField()));
        ps.put(createTypeProperty(writeable));
        ps.put(createInitValueProperty(writeable));
        return sheet;
    }

    /** Create a property for the field type.
    * @param canW <code>false</code> to force property to be read-only
    * @return the property
    */
    protected Node.Property createTypeProperty(boolean canW) {
        Node.Property prop = createTypeProperty(PROP_TYPE, getField(), canW);
        prop.setValue("acceptVoidType", Boolean.FALSE); // NOI18N
        return prop;
    }

    /** Create a property for the field init value.
    * @param canW <code>false</code> to force property to be read-only
    * @return the property
    */
    protected Node.Property createInitValueProperty(boolean canW) {
        return new ElementNode.ElementProp(PROP_INIT_VALUE, String.class, canW) {

            public Object getValue () {
                String val = getField().getInitialValueText(); 
                return val != null? val: ""; // NOI18N
            }
            
            /** Sets the value */
            public void setValue(final Object val) throws IllegalArgumentException,
                   IllegalAccessException, InvocationTargetException {
               
                super.setValue(val);
                if (!(val instanceof String)) throw new IllegalArgumentException();
                
                boolean fail = true;
                try {
                    JavaMetamodel.getDefaultRepository().beginTrans(true);
                    try {
                        getField().setInitialValueText((String) val);
                        fail = false;
                    } finally {
                        JavaMetamodel.getDefaultRepository().endTrans(fail);
                    }
                } catch (JmiException e) {
                    IllegalArgumentException iae = new IllegalArgumentException();
                    iae.initCause(e);
                    ErrorManager.getDefault().annotate(iae, ErrorManager.USER, null,
                            NbBundle.getMessage(FieldNode.class, "MSG_InvalidInitVal"), null, null); // NOI18N
                    throw iae;
                }
            }
        };
    }
    
    private Field getField() {
        return (Field) this.element;
    }

}
