/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.ui.nodes.elements;

import java.awt.BorderLayout;
import java.awt.event.KeyEvent;
import java.beans.FeatureDescriptor;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Iterator;
import java.util.ArrayList;

import javax.swing.*;
import javax.jmi.reflect.JmiException;
import org.netbeans.modules.javacore.jmiimpl.javamodel.TypeClassImpl;

import org.openide.*;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.util.Utilities;
import org.openide.util.NbBundle;

import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.java.ui.nodes.editors.TypeEditor;
import org.netbeans.jmi.javamodel.*;

/** Customizer for MethodElement and ConstructorElement
 *
 * @author Petr Hamernik
 */
public final class MethodCustomizer extends JPanel {
    /** Predefined types in the type combo;
     *  duplicate of {@link org.netbeans.modules.java.ui.nodes.editors.TypeEditor#RVALUE_TYPES}
     */ 
    private static final String[] COMMON_TYPES = TypeEditor.RVALUE_TYPES;

    /**
     * class where the customized method should be added 
     */ 
    private final JavaClass jclass;
    
    /** Edited constructor */
    private final CallableFeature element;

    /** In case that method is edited - this field holds
    * the reference to it. Otherwise (Constructor) this field
    * is <CODE>null</CODE>.
    */
    private final Method method;
    
    private final boolean isConstructor;
    
    private boolean isOK = true;

    /** Create new MethodCustomizer component
    * @param jclass class where the customized method should be added
    * @param element The method or constructor to be customized
    */
    public MethodCustomizer(JavaClass jclass, CallableFeature element) {
        this.jclass = jclass;
        this.element = element;
        this.isConstructor = !(element instanceof Method);
        this.method = this.isConstructor? null: (Method) element;

        initComponents ();

        // modifiers
        int mask;
        if (jclass.isInterface()) {
            mask =  Modifier.PUBLIC | Modifier.ABSTRACT;
        } else {
            mask = Modifier.PUBLIC | Modifier.PROTECTED | Modifier.PRIVATE;
            if (!isConstructor) {
                mask |= Modifier.ABSTRACT | Modifier.STATIC | Modifier.SYNCHRONIZED |
                        Modifier.FINAL | Modifier.NATIVE; 
            }
        }
        accessPanel.add(SourceEditSupport.createAccessModifiersPanel(element, mask), BorderLayout.CENTER);
        
        PropertyPanel modifEditor = SourceEditSupport.createOtherModifiersPanel(element, mask);
        FeatureDescriptor fd = modifEditor.getProperty();
        final String mnc = String.valueOf(KeyEvent.CHAR_UNDEFINED);
        fd.setValue("ModifierPanel_Modifier_Abstract_Mnemonic", mnc); // NOI18N
        fd.setValue("ModifierPanel_Modifier_Final_Mnemonic", mnc); // NOI18N
        fd.setValue("ModifierPanel_Modifier_Static_Mnemonic", mnc); // NOI18N
        fd.setValue("ModifierPanel_Modifier_Synchronized_Mnemonic", mnc); // NOI18N
        fd.setValue("ModifierPanel_Modifier_Transient_Mnemonic", mnc); // NOI18N
        fd.setValue("ModifierPanel_Modifier_Volatile_Mnemonic", mnc); // NOI18N
        fd.setValue("ModifierPanel_Modifier_Native_Mnemonic", mnc); // NOI18N
        modifierPanel.add(modifEditor, BorderLayout.CENTER);

        // name
        if (this.isConstructor) {
            nameTextField.setText(jclass.getSimpleName());
            nameTextField.setEnabled(false);
            returnCombo.setEnabled(false);
        }
        else {
            nameTextField.setText(element.getName());
            returnCombo.setSelectedItem(ElementFormat.elementName(method.getType()));
        }

        // parameters
        PropertyPanel paramsEditor = new PropertyPanel(
                ElementNode.createParametersProperty(element, true),
                PropertyPanel.PREF_CUSTOM_EDITOR
        );
        fd = paramsEditor.getProperty();
        fd.setValue("mnemonic_Add", getString("CTL_Parameters_Mnemonic_Add")); // NOI18N
        fd.setValue("mnemonic_Remove", getString("CTL_Parameters_Mnemonic_Remove")); // NOI18N
        fd.setValue("mnemonic_Up", getString("CTL_Parameters_Mnemonic_Up")); // NOI18N
        fd.setValue("mnemonic_Down", getString("CTL_Parameters_Mnemonic_Down")); // NOI18N
        fd.setValue("mnemonic_Edit", getString("CTL_Parameters_Mnemonic_Edit")); // NOI18N
        paramsPanel.add(paramsEditor, BorderLayout.CENTER);
        
        // exceptions
        PropertyPanel exceptionsEditor = new PropertyPanel(
                ElementNode.createExceptionsProperty(element, true),
                PropertyPanel.PREF_CUSTOM_EDITOR
        );
        fd = exceptionsEditor.getProperty();
        fd.setValue("mnemonic_Add", getString("CTL_Parameters_Mnemonic_Add")); // NOI18N
        fd.setValue("mnemonic_Remove", getString("CTL_Parameters_Mnemonic_Remove")); // NOI18N
        fd.setValue("mnemonic_Up", getString("CTL_Parameters_Mnemonic_Up")); // NOI18N
        fd.setValue("mnemonic_Down", getString("CTL_Parameters_Mnemonic_Down")); // NOI18N
        fd.setValue("mnemonic_Edit", getString("CTL_Parameters_Mnemonic_Edit")); // NOI18N
        exceptionsPanel.add(exceptionsEditor, BorderLayout.CENTER);

        //mnemonics
        jLabel1.setDisplayedMnemonic(getString("CTL_Name_Mnemonic").charAt(0)); // NOI18N
        jLabel2.setDisplayedMnemonic(getString("CTL_MethodType_Mnemonic").charAt(0));  // NOI18N
        
        // XXX generics not yet implemented
        jLabel3.setVisible(false);
        typeTextField.setVisible(false);
        
        initAccessibility();
    }
    
    public void addNotify() {
        super.addNotify();
        
        int len = nameTextField.getText().length();
        nameTextField.setCaretPosition(0);
        nameTextField.moveCaretPosition(len);
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                nameTextField.requestFocus();
            }
        });
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        nameTextField = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        typeTextField = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        returnCombo = new javax.swing.JComboBox(COMMON_TYPES);
        jLabel4 = new javax.swing.JLabel();
        accessPanel = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        modifierPanel = new javax.swing.JPanel();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        paramsPanel = new javax.swing.JPanel();
        exceptionsPanel = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(6, 6, 6, 6)));
        jLabel1.setLabelFor(nameTextField);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(MethodCustomizer.class, "CTL_Name"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        add(jLabel1, gridBagConstraints);

        nameTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                nameTextFieldFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 8, 0, 0);
        add(nameTextField, gridBagConstraints);
        nameTextField.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(MethodCustomizer.class, "ACSD_MethodNameTextField"));

        jLabel3.setLabelFor(typeTextField);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, org.openide.util.NbBundle.getMessage(MethodCustomizer.class, "CTL_Generic_Type"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 0, 0, 0);
        add(jLabel3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 0, 0);
        add(typeTextField, gridBagConstraints);
        typeTextField.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(MethodCustomizer.class, "ACSD_MethodType"));

        jLabel2.setLabelFor(returnCombo);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(MethodCustomizer.class, "CTL_ReturnType"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 0, 0, 0);
        add(jLabel2, gridBagConstraints);

        returnCombo.setEditable(true);
        returnCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                returnComboActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 0, 0);
        add(returnCombo, gridBagConstraints);
        returnCombo.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(MethodCustomizer.class, "ACSD_MethodReturnType"));

        jLabel4.setLabelFor(accessPanel);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel4, org.openide.util.NbBundle.getBundle(MethodCustomizer.class).getString("CTL_AccessRights"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 0, 0, 0);
        add(jLabel4, gridBagConstraints);

        accessPanel.setLayout(new java.awt.BorderLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 0, 0);
        add(accessPanel, gridBagConstraints);

        jLabel5.setLabelFor(modifierPanel);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel5, org.openide.util.NbBundle.getMessage(MethodCustomizer.class, "CTL_Modifiers"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 0, 0, 0);
        add(jLabel5, gridBagConstraints);

        modifierPanel.setLayout(new java.awt.BorderLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 0, 0);
        add(modifierPanel, gridBagConstraints);

        paramsPanel.setLayout(new java.awt.BorderLayout());

        paramsPanel.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(0, 0, 10, 0)));
        jTabbedPane1.addTab(org.openide.util.NbBundle.getMessage(MethodCustomizer.class, "CTL_Parameters"), paramsPanel);

        exceptionsPanel.setLayout(new java.awt.BorderLayout());

        exceptionsPanel.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(0, 0, 10, 0)));
        jTabbedPane1.addTab(org.openide.util.NbBundle.getMessage(MethodCustomizer.class, "CTL_Exceptions"), exceptionsPanel);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        add(jTabbedPane1, gridBagConstraints);

    }
    // </editor-fold>//GEN-END:initComponents

    private void returnComboActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_returnComboActionPerformed
        Object selItem = returnCombo.getSelectedItem();
        if (isConstructor || selItem == null)
           return;
        
        String selItemTxt = selItem.toString().trim();
        Type oldValue = method.getType();
        boolean ok = false;
        
        try {
            Type newValue = getJModel().getType().resolve(selItemTxt);
            if (oldValue.equals(newValue)) {
                return;
            } else if (!TypeEditor.isValidTypeSyntax(selItemTxt)) {
                notifyUserWarning("MSG_Not_Valid_Type", "invalid type"); // NOI18N
            } else {
                method.setType(newValue);
                ok = true;
            }
        } catch (JmiException e) {
            ErrorManager.getDefault().notify(e);
        }
        isOK = ok;
        if (!ok)
            returnCombo.setSelectedItem(ElementFormat.elementName(oldValue));
    }//GEN-LAST:event_returnComboActionPerformed
    
    private void nameTextFieldFocusLost (java.awt.event.FocusEvent evt) {//GEN-FIRST:event_nameTextFieldFocusLost
        if ((evt != null && (evt.isTemporary() || !this.isAncestorOf(evt.getOppositeComponent()))) || isConstructor)
            return;
        
        String newName = nameTextField.getText().trim();
        String oldName = method.getName();
        boolean ok = false;
        
        try {
            if (evt == null) { // final check for OK button
                if (oldName.equals(newName)) {
                    // no name change on OK button
                } else if (!Utilities.isJavaIdentifier(newName)) {
                    notifyUserWarning("MSG_Not_Valid_Identifier", "invalid name"); // NOI18N
                    isOK = false;
                    nameTextField.setText(oldName);
                    return;
                } else {
                    method.setName(newName);
                }
                
                
                Method met = this.jclass.getMethod(newName, params2Types(element.getParameters()), true);
                if (met != null) {
                    Type retType = TypeClassImpl.getRawType(element.getType());
                    if (retType instanceof UnresolvedClass) { // [PENDING]
                        Type type = getJModel().getType().resolve("java.lang." + retType.getName()); // NOI18N
                        if (!(type instanceof UnresolvedClass))
                            retType = type;
                    }
                    if (met.getDeclaringClass() == this.jclass) {
                        notifyUserWarning("MSG_Used_Identifier", newName, "invalid name"); // NOI18N
                    } else if (TypeClassImpl.getRawType(met.getType()) != retType) {
                        notifyUserWarning("MSG_Another_Return_Type", newName, "invalid name"); // NOI18N
                    } else if (Modifier.isFinal(met.getModifiers())) {
                        notifyUserWarning("MSG_Final_Method_Overriden", met.getDeclaringClass().getName(), "invalid name"); // NOI18N
                    } else {
                        ok = true;
                    }
                } else {
                    ok = true;
                }
            } else if (!Utilities.isJavaIdentifier(newName)) {
                notifyUserWarning("MSG_Not_Valid_Identifier", "invalid name"); // NOI18N
            } else if (oldName.equals(newName)) {
                return; // nothing to change
            } else {
                method.setName(newName);
                ok = true;
            }
        } catch (JmiException e) {
            ErrorManager.getDefault().notify(e);
        }
        isOK = ok;
        if (!ok) {
           nameTextField.setText(oldName);
        }
    }//GEN-LAST:event_nameTextFieldFocusLost
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel accessPanel;
    private javax.swing.JPanel exceptionsPanel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JPanel modifierPanel;
    private javax.swing.JTextField nameTextField;
    private javax.swing.JPanel paramsPanel;
    private javax.swing.JComboBox returnCombo;
    private javax.swing.JTextField typeTextField;
    // End of variables declaration//GEN-END:variables

    private void initAccessibility() {
        nameTextField.getAccessibleContext().setAccessibleName(getString("ACS_MethodNameTextField")); // NOI18N
        nameTextField.getAccessibleContext().setAccessibleDescription(getString("ACS_MethodNameTextField")); // NOI18N
        this.getAccessibleContext().setAccessibleDescription(getString("ACSD_MethodCustomizerDialog")); // NOI18N
    }                       
    
    public boolean isOK() {
        nameTextFieldFocusLost(null);
        if (isOK) {
            returnComboActionPerformed(null);
        }
        return isOK;
    }
    
    private JavaModelPackage getJModel() {
        return JavaMetamodel.getManager().getJavaExtent(this.jclass);
    }
    
    private static String getString(String key) {
        return NbBundle.getMessage(MethodCustomizer.class, key);
    }
    
    private static void notifyUserWarning(String bundleKey, String msg) {
        IllegalArgumentException e = new IllegalArgumentException(msg);
        ErrorManager.getDefault().annotate(
            e, ErrorManager.USER, null, 
            getString(bundleKey),
            null, null);
        ErrorManager.getDefault().notify(e);
    }
    
    private static void notifyUserWarning(String bundleKey, String param, String msg) {
        IllegalArgumentException e = new IllegalArgumentException(msg);
        ErrorManager.getDefault().annotate(
            e, ErrorManager.USER, null, 
            NbBundle.getMessage(MethodCustomizer.class, bundleKey, param),
            null, null);
        ErrorManager.getDefault().notify(e);
    }
    
    private static List/*<Type>*/ params2Types(List/*<Parameter>*/ params) {
        List/*<Type>*/ types = new ArrayList/*<Type>*/(params.size());
        for (Iterator it = params.iterator(); it.hasNext();) {
            Parameter p = (Parameter) it.next();
            Type t = p.getType();
            types.add(t);
        }
        return types;
    }
}
