/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.java.ui.wizard;

import java.util.ResourceBundle;
import java.util.StringTokenizer;

import org.openide.src.*;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Utilities;

public class Util {
    static String getString(String key) {
        return org.openide.util.NbBundle.getMessage(Util.class, key);
    }
    
    /** Returns true, if the passed string can be used as a qualified identifier.
     * it does not check for semantic, only for syntax.
     * The function returns true for any sequence of identifiers separated by
     * dots.
     */
    static boolean isValidPackageName(String str) {
        if (str.length() > 0 && str.charAt(0) == '.') return false;
        StringTokenizer tukac = new StringTokenizer(str, "."); // NOI18N
        while (tukac.hasMoreTokens()) {
            String token = tukac.nextToken();
            if ("".equals(token))
                return false;
            if (!Utilities.isJavaIdentifier(token))
                return false;
        }
        return true;
    }
    
    static boolean isValidTypeIdentifier(String ident) {
        if (ident == null || "".equals(ident))
            return false;
        try {
            Type t = Type.parse(ident);
            return t.isClass();
        } catch (IllegalArgumentException e) {
            return false;
        }
    }
    
    static boolean implementsInterface(ClassElement clazz, Identifier id) {
        Identifier[] implemented = clazz.getInterfaces();
        for (int i = 0; i < implemented.length; i++) {
            if (implemented[i].equals(id)) {
                return true;
            }
        }
        return false;
    }
    
    static TemplateWizard.Iterator packageIt;
    
    public static TemplateWizard.Iterator createPackageIterator() {
        if (packageIt == null)
            packageIt = JavaPackageIterator.create();
        return packageIt;
    }
}
