/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.api.java.comparators;

import org.openide.src.ClassElement;
import java.util.Comparator;

class ClassComparator extends MemberNameComparator {

    protected ClassComparator(int type) {
        super(type);
    }    

    public int compare(Object o1, Object o2) {
        boolean o1Class,o2Class;
        ClassElement ce1=(ClassElement)o1;
        ClassElement ce2=(ClassElement)o2;
        int result;
        
        if ((type&NAME)!=0) {
            result=super.compare(ce1,ce2);
            if (result!=0) return result;
        }
        if ((type&ISCLASS)!=0) {
            o2Class=ce1.isClassOrInterface();
            o1Class=ce2.isClassOrInterface();
            return (o1Class?1:0)-(o2Class?1:0);
        }
        return 0;
    }
    
    static Comparator createComparator(int type) {
        return new ClassComparator(type);
    }
    
}

