/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.api.java.comparators;

import org.openide.src.FieldElement;
import java.util.Comparator;

class FieldComparator extends MemberNameComparator {
    private Comparator typeComparator;    
    
    protected FieldComparator(int type) {
        super(type);
        if ((type&TYPE)!=0) {
            typeComparator=TypeComparator.createComparator(type&SOURCE);
        }  
    }

    public int compare(Object o1, Object o2) {
        FieldElement fe1=(FieldElement)o1;
        FieldElement fe2=(FieldElement)o2;
        int result;

        if ((type&NAME)!=0) {
            result = super.compare(fe1, fe2);
            if (result!=0) return result;
        }
        if (typeComparator!=null) {
            result = typeComparator.compare(fe1, fe2);
            if (result!=0) return result;
        }
        if ((type&MODIFIERS)!=0) {
            result = fe1.getModifiersMask()-fe2.getModifiersMask();

            if (result<0) return -1;
            if (result==0) return 0;
            return 1;
        }
        return 0;
    }     
    
    static Comparator createComparator(int type) {
        return new FieldComparator(type);
    }
    
}

