/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.api.java.comparators;

import org.openide.src.MethodParameter;
import java.util.Comparator;

class MParameterComparator extends JavaElementComparator {
    private Comparator typeComparator;    
    
    protected MParameterComparator(int type) {
        super(type);
        if ((type&TYPE)!=0) {
            typeComparator=TypeComparator.createComparator(type&SOURCE);
        }  
    }

    public int compare(Object o1, Object o2) {
        MethodParameter mp1=(MethodParameter)o1;
        MethodParameter mp2=(MethodParameter)o2;
        int result;

        if (typeComparator!=null) {
            result = typeComparator.compare(mp1.getType(),mp2.getType());
            if (result!=0) return result;
        }
        if ((this.type&NAME)!=0) {
            result=mp1.getName().compareTo(mp2.getName());
            if (result!=0) return result;
        }
        if ((this.type&MODIFIERS)!=0) {
            return (mp1.isFinal()?1:0)-(mp2.isFinal()?1:0);
        }
        return 0;
    }     
    
    static Comparator createComparator(int type) {
        return new MParameterComparator(type);
    }
    
}

