/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.api.java.comparators;

import org.openide.src.MethodElement;
import java.util.Comparator;

class MethodComparator extends ConstructorComparator {

    private Comparator retTypeComparator;    
    
    protected MethodComparator(int type) {
        super(type);
        if ((type&RETURN_TYPE)!=0)
            retTypeComparator=TypeComparator.createComparator(type&SOURCE);
    }

    public int compare(Object o1, Object o2) {
        MethodElement me1=(MethodElement)o1;
        MethodElement me2=(MethodElement)o2;

        if ((type&(NAME|PARAMETERS|EXCEPTIONS))!=0) {
            int result = super.compare(me1, me2);
            if (result!=0)
                return result;
        }
        if (retTypeComparator!=null)
            return retTypeComparator.compare(me1.getReturn(),me2.getReturn()); 
        return 0;
    }      
    
    static Comparator createComparator(int type) {
        return new MethodComparator(type);
    }
    
}

