/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.openide.cookies;

import java.util.NoSuchElementException;

import org.openide.nodes.Node;
import org.openide.src.SourceElement;

/** A cookie for obtaining a source hierarchy from data objects.
*
* @author Dafe Simonek, Petr Hamernik
*/
public interface SourceCookie extends Node.Cookie {

    /** Returns a source element describing the hierarchy
    * of the source.
    *
    * @return the element
    */
    public SourceElement getSource ();

    /** Extended source cookie permitting for bidirectional translation with Swing text elements.
    */
    public interface Editor extends SourceCookie, EditorCookie {
        /** Translate a source element to text.
        *
        * @param element an element from the source hierarchy
        * @return a text element
        */
        public javax.swing.text.Element sourceToText(org.openide.src.Element element);

        /** Translate a text element to a source element, if it is possible to do so.
        *
        * @param element a text element
        * @return the element from the source hierarchy
        * @exception NoSuchElementException if the text element doesn't match
        *  any element from the source hierarchy
        */
        public org.openide.src.Element textToSource(javax.swing.text.Element element)
        throws NoSuchElementException;

        /** Find the element at the specified offset in the document.
        * @param offset The position of the element
        * @return the element at the position.
        */
        public org.openide.src.Element findElement(int offset);
    }
}
