/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.openide.src;

import java.io.PrintWriter;

/** A trivial implementation of <code>ElementPrinter</code>.
* It is backed by the supplied <code>PrintWriter</code>,
* and by default just prints the text as supplied to that print
* writer.
* It does nothing for any of the mark methods, and never
* throws {@link ElementPrinterInterruptException}.
* Subclasses may use this as an adapter for <code>ElementPrinter</code>,
* typically providing a nontrivial body for one of the mark methods.
*
* @author Petr Hamernik
*/
public class DefaultElementPrinter implements ElementPrinter {
    /** The underlaying writer. */
    private PrintWriter writer;

    /** Create a printer.
    * @param writer the writer to send printed text to
    */
    public DefaultElementPrinter(PrintWriter writer) {
        this.writer = writer;
    }

    /* Prints the given text.
    * @param text The text to write
    */
    public void print(String text) {
        writer.print(text);
    }

    /* Prints the line. New-line character '\n' should be added.
    * @param text The line to write
    */
    public void println(String text) {
        writer.println(text);
    }

    /* Marks the notable point of the class element.
    * @param element The element.
    * @param what The kind of the event. It must be one of the integer
    *             constants from this interface
    */
    public void markClass(ClassElement element, int what) throws ElementPrinterInterruptException {
    }

    /* Marks the notable point of the initializer element.
    * @param element The element.
    * @param what The kind of the event. It must be one of the integer
    *             constants from this interface
    */
    public void markInitializer(InitializerElement element, int what) throws ElementPrinterInterruptException {
    }

    /* Marks the notable point of the field element.
    * @param element The element.
    * @param what The kind of the event. It must be one of the integer
    *             constants from this interface
    */
    public void markField(FieldElement element, int what) throws ElementPrinterInterruptException {
    }

    /* Marks the notable point of the constructor element.
    * @param element The element.
    * @param what The kind of the event. It must be one of the integer
    *             constants from this interface
    */
    public void markConstructor(ConstructorElement element, int what) throws ElementPrinterInterruptException {
    }

    /* Marks the notable point of the method element.
    * @param element The element.
    * @param what The kind of the event. It must be one of the integer
    *             constants from this interface
    */
    public void markMethod(MethodElement element, int what) throws ElementPrinterInterruptException {
    }
}
