/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.openide.src;

/** Names of properties of elements.
*
*
* @author Jaroslav Tulach, Svatopluk Dedic
*/
public interface ElementProperties {
    /** Name of {@link FieldElement#getType type} property for {@link FieldElement field elements}.
    */
    public static final String PROP_TYPE = "type"; // NOI18N

    /** Name of {@link FieldElement#getInitValue initial value} property for {@link FieldElement field elements}.
    */
    public static final String PROP_INIT_VALUE = "initValue"; // NOI18N

    /** Name of {@link ConstructorElement#getParameters parameters} property  for {@link MethodElement methods} and {@link ConstructorElement constructors}.
    */
    public static final String PROP_PARAMETERS = "parameters"; // NOI18N

    /** Name of {@link ConstructorElement#getExceptions exceptions} property for {@link ConstructorElement constructors} and {@link MethodElement methods}.
    */
    public static final String PROP_EXCEPTIONS = "exceptions"; // NOI18N

    /** Name of {@link InitializerElement#isStatic static} property for {@link InitializerElement initializers}.
    */
    public static final String PROP_STATIC = "static"; // NOI18N

    /** Name of {@link ConstructorElement#getBody body} property for {@link InitializerElement#getBody initializers}, {@link ConstructorElement constructors} and {@link MethodElement methods}.
    */
    public static final String PROP_BODY = "body"; // NOI18N

    /** Name of {@link MemberElement#getModifiers modifiers} property for {@link ClassElement classes}, {@link ConstructorElement constructors}, {@link MethodElement methods}, and {@link FieldElement fields}.
    */
    public static final String PROP_MODIFIERS = "modifiers"; // NOI18N

    /** Name of {@link MemberElement#getName name} property for {@link ClassElement classes}, {@link ConstructorElement constructors}, {@link MethodElement methods}, and {@link FieldElement fields}.
    */
    public static final String PROP_NAME = "name"; // NOI18N

    /** Name of {@link MethodElement#getReturn return value type} property for {@link MethodElement methods}.
    */
    public static final String PROP_RETURN = "return"; // NOI18N

    /** Name of {@link SourceElement#getPackage package} property for {@link SourceElement source elements}.
    */
    public static final String PROP_PACKAGE = "package"; // NOI18N

    /** Name of {@link SourceElement#getImports imports} property for {@link SourceElement source elements}.
    */
    public static final String PROP_IMPORTS = "imports"; // NOI18N

    /** Name of classes property for {@link SourceElement#getClasses source elements} and {@link ClassElement#getClasses classes}.
    */
    public static final String PROP_CLASSES = "classes"; // NOI18N

    /** Name of {@link SourceElement#getAllClasses all classes} property for {@link SourceElement source elements}.
    */
    public static final String PROP_ALL_CLASSES = "allClasses"; // NOI18N

    /** Name of {@link ClassElement#getInitializers initializers} property for {@link ClassElement classes}.
    */
    public static final String PROP_INITIALIZERS = "initializers"; // NOI18N

    /** Name of {@link ClassElement#getMethods methods} property for {@link ClassElement classes}.
    */
    public static final String PROP_METHODS = "methods"; // NOI18N

    /** Name of {@link ClassElement#getFields fields} property for {@link ClassElement classes}.
    */
    public static final String PROP_FIELDS = "fields"; // NOI18N

    /** Name of {@link ClassElement#getConstructors constructors} property for {@link ClassElement classes}.
    */
    public static final String PROP_CONSTRUCTORS = "constructors"; // NOI18N

    /** Name of {@link ClassElement#getSuperclass super class} property for {@link ClassElement classes}.
    */
    public static final String PROP_SUPERCLASS = "superclass"; // NOI18N

    /** Name of {@link ClassElement#getInterfaces interfaces} property for {@link ClassElement classes}.
    */
    public static final String PROP_INTERFACES = "interfaces"; // NOI18N

    /** Name of {@link SourceElement#getStatus status} property for {@link SourceElement source elements}.
    */
    public static final String PROP_STATUS = "status"; // NOI18N

    /** Name of {@link ClassElement#isClassOrInterface is class or interface} property for {@link ClassElement classes}.
    */
    public static final String PROP_CLASS_OR_INTERFACE = "classOrInterface"; // NOI18N

    /** Name of {@link Element.Impl2#isValid validity} property for {@link Element.Impl2}.
     */
    public static final String PROP_VALID = "valid"; // NOI18N
    
    /** Name of special members property for {@link ClassElement class elements}.
     */
    public static final String PROP_MEMBERS = "members"; // NOI18N
    
    /**
     * Name of Javadoc property for all {@link MemberElement member elements}.
     * @see ClassElement#getJavaDoc
     * @see ConstructorElement#getJavaDoc
     * @see FieldElement#getJavaDoc
     * @see InitializerElement#getJavaDoc
     */
    public static final String PROP_JAVADOC = "javadoc"; // NOI18N
}
