/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.openide.src;

/** Represents one class or package import.
*
* @author Petr Hamernik
*/
public class Import extends Object implements java.io.Serializable {
    /** A package import. */
    public static final boolean PACKAGE = true;
    /** A class import. */
    public static final boolean CLASS = false;

    /** Kind of this Import element. It is true if the import means "whole package"
    * otherwise (if it is import just one class) false.
    */
    private boolean wholePackage;

    /** Identifier which is imported */
    private Identifier id;

    static final long serialVersionUID =-4111760314345461897L;

    /** Create an import.
    * @param id the name of the class or package imported
    * @param wholePackage one of {@link #PACKAGE} or {@link #CLASS}
    */
    public Import(Identifier id, boolean wholePackage) {
        this.wholePackage = wholePackage;
        this.id = id;
    }

    /** Is this a package import?
    * @return <code>true</code> if so
    */
    public boolean isPackage() {
        return wholePackage;
    }

    /** Is this a class import?
    * @return <code>true</code> if so
    */
    public boolean isClass() {
        return (!wholePackage);
    }

    /** Get the name of the import.
    * @return the identifier which is imported
    */
    public Identifier getIdentifier() {
        return id;
    }

    /** Get this import as a string.
    * @return e.g. <code>import com.mycom.Class</code> or <code>import com.mycom.*</code>
    */
    public String toString() {
        StringBuffer buf = new StringBuffer("import "); // NOI18N
        buf.append(id.getFullName());
        if (wholePackage)
            buf.append(".*"); // NOI18N
        return buf.toString();
    }

    /** @return the hash code for this import */
    public int hashCode() {
        return id.getFullName().hashCode();
    }

    /** @return true if the specified object is also Import of the same class or package.
    */
    public boolean equals(Object o) {
        if (o instanceof Import) {
            Import imp = (Import) o;
            return (wholePackage == imp.wholePackage) && (id.equals(imp.id));
        }
        return false;
    }
}
