/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.openide.src;

/** General exception for the source elements hierarchy. */
public class SourceException extends Exception {
    static final long serialVersionUID =4472081442050042697L;
    /** Create an exception. */
    public SourceException() {
        this(null); // NOI18N
    }
    /** Create an exception with a detail message.
    * @param msg the message
    */
    public SourceException(String msg) {
        super(msg);
    }
    
    public static class IO extends SourceException {
        private java.io.IOException     nestedException;
        
        public IO(java.io.IOException cause) {
            this.nestedException = cause;
        }
        
        public IO(String msg) {
            super(msg);
        }
        
        /**
         * Returns the original I/O exception that caused the operation to fail.
         * The function may return null in a generic case.
         */
        public java.io.IOException getReason() {
            return nestedException;
        }
    }
    
    public static class Protection extends SourceException {
        private Element     protectionTarget;
        
        public Protection(Element prot) {
            this.protectionTarget = prot;
        }
        
        public Element getTarget() {
            return this.protectionTarget;
        }
    }
    
    /** This is a wrapper over an unspecified VetoException thrown from a VetoableListener
     * during some change.
     */
    public static class Veto extends SourceException {
        private java.beans.PropertyVetoException   reason;
        
        public Veto(java.beans.PropertyVetoException reason) {
            this.reason = reason;
        }
        
        public java.beans.PropertyVetoException getReason() {
            return this.reason;
        }
    }
}
