/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.openide.src.beaninfo;

import java.awt.Image;
import java.beans.*;
import org.openide.explorer.propertysheet.editors.TypeEditor;

import org.openide.src.*;
import org.openide.util.Utilities;

/**
* Bean info for methods.
*
* @author Petr Hamernik
*/
public class MethodElementBeanInfo extends ConstructorElementBeanInfo {

    /**
    * Return the icon
    */
    public Image getIcon(int type) {
        return Utilities.loadImage("org/openide/src/resources/methodPublic.gif"); // NOI18N
    }

    /** @return Propertydescriptors */
    public PropertyDescriptor[] getPropertyDescriptors() {
        PropertyDescriptor[] inh = super.getPropertyDescriptors();
        PropertyDescriptor[] desc = new PropertyDescriptor[inh.length + 1];
        System.arraycopy(inh, 0, desc, 0, inh.length);
        try {
            desc[inh.length] = new PropertyDescriptor(PROP_RETURN, MethodElement.class, "getReturn", "setReturn"); // NOI18N
            desc[inh.length].setPropertyEditorClass(TypeEditor.class);
	    desc[inh.length].setDisplayName(getString("PROP_METHOD_TYPE")); // NOI18N
            return desc;
        } catch (IntrospectionException ex) {
            return inh;
        }
    }
}
