/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.openide.src.nodes;

import java.beans.*;
import java.awt.Image;
import java.util.ResourceBundle;

import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.ErrorManager;

/** BeanInfo for source options.
*
* @author Petr Hamernik
*/
public final class SourceOptionsBeanInfo extends SimpleBeanInfo {
    /** Prefix of the icon location. */

    public BeanDescriptor getBeanDescriptor() {
        ResourceBundle bundle = NbBundle.getBundle(SourceOptionsBeanInfo.class);
        BeanDescriptor desc = new BeanDescriptor(SourceOptions.class);
        desc.setDisplayName(bundle.getString("MSG_sourceOptions"));
        /* for Post-FCS desc.setShortDescription(bundle.getString("HINT_sourceOptions")); */
        return desc;
    }

    /*
    * @return Returns an array of PropertyDescriptors
    * describing the editable properties supported by this bean.
    */
    public PropertyDescriptor[] getPropertyDescriptors () {
        try {
    	    ResourceBundle bundle = NbBundle.getBundle(SourceOptionsBeanInfo.class);
            PropertyDescriptor[] descriptors = new PropertyDescriptor[6];
            for (int i = 0; i < 6; i++) {
                descriptors[i] = new PropertyDescriptor(SourceOptions.PROP_NAMES[i], SourceOptions.class);
                descriptors[i].setDisplayName(bundle.getString("PROP_"+SourceOptions.PROP_NAMES[i]));
                descriptors[i].setShortDescription(bundle.getString("HINT_"+SourceOptions.PROP_NAMES[i]));
            }
            //        descriptors[6] = new PropertyDescriptor(SourceOptions.PROP_CATEGORIES_USAGE, SourceOptions.class);
            //        descriptors[6].setDisplayName(bundle.getString("PROP_"+SourceOptions.PROP_CATEGORIES_USAGE));
            //        descriptors[6].setShortDescription(bundle.getString("HINT_"+SourceOptions.PROP_CATEGORIES_USAGE));
    	    return descriptors;
        } catch (IntrospectionException e) {
	    ErrorManager.getDefault().notify(e);
	    return null;
        }
    }

    /* @param type Desired type of the icon
    * @return returns the Java loader's icon
    */
    public Image getIcon(final int type) {
        if ((type == BeanInfo.ICON_COLOR_16x16) || (type == BeanInfo.ICON_MONO_16x16)) {
	    return Utilities.loadImage("org/openide/src/resources/sourceOptions.gif"); // NOI18N
        }
        else {
            return Utilities.loadImage("org/openide/src/resources/sourceOptions32.gif"); // NOI18N
        }
    }
}
