/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.openide.src.resources;

import java.beans.Introspector;
import java.beans.PropertyEditorManager;

import org.openide.modules.ModuleInstall;

/** Register BeanInfo's for org.openide.src.* objects.
 * @author Jesse Glick
 */
public class Install extends ModuleInstall {
    
    public void restored() {
        String[] sysbisp = Introspector.getBeanInfoSearchPath();
        String[] nbbisp = new String[] {
            "org.openide.src.beaninfo", // NOI18N
        };
        String[] allbisp = new String[sysbisp.length + nbbisp.length];
        System.arraycopy(nbbisp, 0, allbisp, 0, nbbisp.length);
        System.arraycopy(sysbisp, 0, allbisp, nbbisp.length, sysbisp.length);
        Introspector.setBeanInfoSearchPath(allbisp);
        PropertyEditorManager.registerEditor(getKlass("[Lorg.openide.src.MethodParameter;"), getKlass("org.openide.explorer.propertysheet.editors.MethodParameterArrayEditor")); // NOI18N
        PropertyEditorManager.registerEditor(getKlass("[Lorg.openide.src.Identifier;"), getKlass("org.openide.explorer.propertysheet.editors.IdentifierArrayEditor")); // NOI18N
    }

    private static Class getKlass(String cls) {
        try {
            return Class.forName(cls, false, Install.class.getClassLoader());
        } catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.toString());
        }
    }
}
