/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.lib.java.storagebuilder;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.api.mdr.MDRManager;
import org.netbeans.mdr.NBMDRepositoryImpl;

public class MDRManagerImpl extends MDRManager {

    // private static final String DEFAULT_REPOSITORY = "Default";
    private static final String JAVA_REPOSITORY = "org.netbeans.java"; // NOI18N
    
    private Map parameters;
    private MDRepository repository = null;
    private String[] repositoryNames;
    
    private void init() {
        if (repository == null) {
            repositoryNames = new String[] {JAVA_REPOSITORY};
            String storagesDir = System.getProperty("mdr.filename"); // NOI18N
            System.out.println(" " + storagesDir); // NOI18N
            if (storagesDir == null) {
                System.out.println();
                System.out.println("Cannot init mdr, mdr.filename property not specified."); // NOI18N
                return;
            }
            parameters = new HashMap();
            parameters.put("storage", "org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeFactory"); // NOI18N
            parameters.put("mutexClass", "org.netbeans.modules.javacore.ExclusiveMutex"); // NOI18N
            parameters.put("org.netbeans.mdr.persistence.btreeimpl.filename", storagesDir); // NOI18N
            parameters.put("org.netbeans.mdr.persistence.btreeimpl.cacheSize", "256"); // NOI18N
            parameters.put("org.netbeans.mdr.persistence.btreeimpl.cacheThreshHold", "1000"); // NOI18N
            parameters.put("org.netbeans.mdr.persistence.btreeimpl.uuid", "66666666-6666-6666-6666-666666666666"); // NOI18N
            repository = new NBMDRepositoryImpl(parameters);
        }
    }
    
    public MDRepository getRepository(String name) {
        init();
        return repository;
    }

    public MDRepository getDefaultRepository() {
        return getRepository(JAVA_REPOSITORY);
    }

    public String[] getRepositoryNames() {
        init();
        return repositoryNames;
    }
    
}
