/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * ClassChanged.java
 *
 * Created on June 26, 2000, 9:29 AM
 */

package org.netbeans.test.java.eventfiring.ClassChanged;

import org.netbeans.test.java.eventfiring.MyListener;
//import org.netbeans.modules.java.JavaConnections.Type;
import org.openide.src.Identifier;
import org.openide.src.ClassElement;
import java.lang.reflect.Modifier;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.java.JavaDataObject;
import org.openide.cookies.ConnectionCookie;
import org.netbeans.test.java.Common;
import org.openide.loaders.DataObject;

/**
 * @author Jan Becicka <Jan.Becicka@sun.com>
 */

public class ClassChanged extends org.netbeans.test.java.XRunner {
    
    final static int DELAY = 2000;
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public ClassChanged() {
        super("");
    }
    
    public ClassChanged(java.lang.String testName) {
        super(testName);
    }
    
    public static org.netbeans.junit.NbTest suite() {
        return new org.netbeans.junit.NbTestSuite(ClassChanged.class);
    }
    
    /** "body" of this TestCase
     * @param o SourceElement - target for generating
     * @param log log is used for logging StackTraces
     * @throws Exception
     * @return true if test passed
     * false if failed
     */
    public boolean go(Object o, java.io.PrintWriter log) throws Exception {
        
        ClassElement clazz = ((org.openide.src.SourceElement) o).getClasses()[0];
        System.setProperty(MyListener.RESULT_KEY,"");
        boolean passed = true;
        
        clazz.addPropertyChangeListener(new PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent ev) {
                if (!ev.getPropertyName().equals("cookie")) { //hack to slow event firing
                    ref("PropertyChanged: "+ev.getPropertyName());
                }
            }
        });
        
        JavaDataObject DO = (JavaDataObject)  clazz.getSource().getCookie(JavaDataObject.class);
        ConnectionCookie cc = (ConnectionCookie)  DO.getCookie(ConnectionCookie.class);
        MyListener  l = new MyListener();
        //Type t = new Type(org.netbeans.modules.java.JavaConnections.TYPE_ALL);
        
        Thread.currentThread().sleep(DELAY * 4);
        //cc.register(t, l);
        ClassElement innerClass = new ClassElement();
        innerClass.setModifiers(Modifier.PUBLIC | Modifier.SYNCHRONIZED);
        innerClass.setSuperclass(Identifier.create("Object"));
        innerClass.setName(Identifier.create("InnerClass","InnerClass"));
        
        Thread.currentThread().sleep(DELAY);
        
        clazz.addMethod(Common.createMethod("method1", Modifier.PRIVATE | Modifier.SYNCHRONIZED, org.openide.src.Type.INT, Common.PARS2));
        log.println("add method");
        Thread.currentThread().sleep(DELAY);
        
        clazz.addField(Common.createField("field"));
        log.println("add field");
        Thread.currentThread().sleep(DELAY);
        
        clazz.addConstructor(Common.createConstructor(null,Common.PARS1));
        log.println("add constructor");
        Thread.currentThread().sleep(DELAY);
        
        clazz.addClass(innerClass);
        log.println("add inner class");
        Thread.currentThread().sleep(DELAY);
        
        clazz.addInitializer(Common.createInitializer());
        log.println("add initializer");
        Thread.currentThread().sleep(DELAY);
        
        clazz.addInterface(Identifier.create("Serializable"));
        log.println("add interface");
        Thread.currentThread().sleep(DELAY);
        
        clazz.removeFields(clazz.getFields());
        log.println("remove fields");
        Thread.currentThread().sleep(DELAY);
        
        clazz.removeMethods(clazz.getMethods());
        log.println("remove methods");
        Thread.currentThread().sleep(DELAY);
        
        clazz.removeClasses(clazz.getClasses());
        log.println("remove classes");
        Thread.currentThread().sleep(DELAY);
        
        clazz.removeInitializers(clazz.getInitializers());
        log.println("remove initializers");
        Thread.currentThread().sleep(DELAY);
        
        clazz.removeInterface(clazz.getInterfaces());
        log.println("remove interfaces");
        Thread.currentThread().sleep(DELAY);
        
        clazz.removeConstructors(clazz.getConstructors());
        log.println("remove constructors");
        Thread.currentThread().sleep(DELAY);
        
        //cc.unregister(t, l);
        
        ref(System.getProperty(MyListener.RESULT_KEY));
        
        return passed;
    }
    
    protected boolean writeResult(DataObject DO) {
        return true;
    }
    
    /**
     */
    protected void setUp() {
        super.setUp();
        name = "JavaTestSourceEventFiringClassChanged";
        packageName = "org.netbeans.test.java.testsources";
    }
    
    protected void tearDown() {
        try {
            Thread.sleep(2*DELAY);
        } catch (InterruptedException e) {
        }
        super.tearDown();
    }
    
}
