/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * ConstructorChanged.java
 *
 * Created on June 26, 2000, 9:29 AM
 */

package org.netbeans.test.java.eventfiring.ConstructorChanged;

import org.netbeans.test.java.eventfiring.MyListener;
//import org.netbeans.modules.java.JavaConnections.Type;
import org.openide.src.Identifier;
import org.openide.cookies.ConnectionCookie;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.test.java.Common;
import org.openide.loaders.DataObject;

/**
 * @author Jan Becicka <Jan.Becicka@sun.com>
 */

public class ConstructorChanged extends org.netbeans.test.java.XRunner {
    
    final static int DELAY = 2000;
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public ConstructorChanged() {
        super("");
    }
    
    public ConstructorChanged(java.lang.String testName) {
        super(testName);
    }
    
    public static org.netbeans.junit.NbTest suite() {
        return new org.netbeans.junit.NbTestSuite(ConstructorChanged.class);
    }
    
    /** "body" of this TestCase
     * @param o SourceElement - target for generating
     * @param log log is used for logging StackTraces
     * @throws Exception
     * @return true if test passed
     * false if failed
     */
    public boolean go(Object o, java.io.PrintWriter log) throws Exception {
        
        org.openide.src.ClassElement clazz = ((org.openide.src.SourceElement) o).getClasses()[0];
        System.setProperty(MyListener.RESULT_KEY,"");
        boolean passed = true;
        
        JavaDataObject DO = (JavaDataObject)  clazz.getSource().getCookie(JavaDataObject.class);
        ConnectionCookie cc = (ConnectionCookie)  DO.getCookie(ConnectionCookie.class);
        MyListener  l = new MyListener();
        //Type t = new Type(org.netbeans.modules.java.JavaConnections.TYPE_ALL);
        
        Thread.currentThread().sleep(DELAY*3);
        //cc.register(t, l);
        
        org.openide.src.ConstructorElement ce = Common.createConstructor(null,Common.PARS1);
        
        clazz.addConstructor(ce);
        ce = clazz.getConstructor(Common.TPARS1);
        
        Thread.currentThread().sleep(DELAY*3);
        ce.addPropertyChangeListener(new PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent ev) {
                if (!ev.getPropertyName().equals("cookie")) { //hack to slow event firing
                    ref("PropertyChanged: "+ev.getPropertyName());
                }
            }
        });
        
        Thread.currentThread().sleep(DELAY);
        
        ce.setBody("//blah\n");
        log.println("set body");
        Thread.currentThread().sleep(DELAY);
        
        ce.setExceptions(new Identifier[]{Identifier.create("java.lang.Exception","java.io.IOException")});
        log.println("set exceptions");
        Thread.currentThread().sleep(DELAY);
        
        ce.setModifiers(java.lang.reflect.Modifier.PROTECTED);
        log.println("set modifiers");
        Thread.currentThread().sleep(DELAY);
        
        ce.setParameters(Common.PARS2);
        log.println("set parameters");
        Thread.currentThread().sleep(DELAY);
        
        //cc.unregister(t, l);
        
        ref(System.getProperty(MyListener.RESULT_KEY));
        
        return passed;
    }
    
    protected boolean writeResult(DataObject DO) {
        return true;
    }
    
    /**
     */
    protected void setUp() {
        super.setUp();
        name = "JavaTestSourceEventFiringConstructorsChanged";
        packageName = "org.netbeans.test.java.testsources";
    }
    
    protected void tearDown() {
        try {
            Thread.sleep(2*DELAY);
        } catch (InterruptedException e) {
        }
        super.tearDown();
    }
    
}
