/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * FieldElem.java
 *
 * Created on June 26, 2000, 9:29 AM
 */

package org.netbeans.test.java.generating.InnerClasses;

import org.netbeans.test.java.Common;
import org.openide.src.*;
import java.lang.reflect.Modifier;
import org.openide.loaders.*;
import org.netbeans.junit.*;

/** <B>Java Module General API test: InnerClasses</B>
 * <BR><BR><I>What it tests:</I><BR>
 * Creating and handling with ClassElement.
 * Test is focused on checking of correctness of generated code.
 * <BR><BR><I>How it works</I><BR>
 * New class is created using DataObject.createFromTemplate() and also some ClassElements are created.
 * These are customized using setters and filled with fields, methods etc.
 * Then these ClassElements are added using ClassElement.addClass() into ClassElement.
 * These action cause generating of .java code. This code is compared with supposed one.
 * <BR><BR><I>Output</I><BR>
 * Generated Java code.
 * <BR><BR><I>Possible reasons of failure</I><BR>
 * <U>Classes are not inserted properly:</U><BR>
 * If there are some Initialzers in .diff file.
 * <BR><BR><U>Classes have/return bad properies</U><BR>
 * See .diff file to get which ones
 * <BR><BR><U>Bad indentation</U><BR>
 * This is probably not a bug of Java Module. (->Editor Bug)
 * In .diff file could be some whitespaces.
 * <BR><BR><U>Exception occured</U><BR><BR>
 * See .log file for StackTrace
 *
 * @author Jan Becicka <Jan.Becicka@sun.com>
 */


public class InnerClasses extends org.netbeans.test.java.XRunner {
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public InnerClasses() {
        super("");
    }
    
    public InnerClasses(java.lang.String testName) {
        super(testName);
    }
    
    public static NbTest suite() {
        return new NbTestSuite(InnerClasses.class);
    }
    
    /** "body" of this TestCase
     * @param o SourceElement - target for generating
     * @param log log is used for logging StackTraces
     * @throws Exception
     * @return true if test passed
     * false if failed
     */
    public boolean go(Object o, java.io.PrintWriter log) throws Exception {
        
        org.openide.src.ClassElement clazz = ((org.openide.src.SourceElement) o).getClasses()[0];
        boolean passed = true;
    
        ClassElement innerClass = new ClassElement();
        
        simpleJavaSourceEtalonGenerator(innerClass);
        
        innerClass.setModifiers(Modifier.PUBLIC | Modifier.SYNCHRONIZED);
        innerClass.setSuperclass(Identifier.create("Object"));
        innerClass.setName(Identifier.create("InnerClass","InnerClass"));
        clazz.addClass(innerClass);
        
        innerClass = clazz.getClass(Identifier.create("InnerClass"));
        
        if (!(innerClass.getDeclaringClass().getName().getFullName().equals(packageName + "." + name))){
            passed = false;
            log("getDeclaringClass failed");
        }
        
        DataObject DO = (DataObject)  clazz.getSource().getCookie(DataObject.class);
        //DO.rename("RenamedJavaTestSource");
        clazz.setName(Identifier.create("RenamedJavaTestSource"));
        
        if (!(innerClass.getDeclaringClass().getName().getFullName().equals(packageName + ".RenamedJavaTestSource"))){
            passed = false;
            log("getDeclaringClass failed");
        }
        
        if (!(innerClass.getMethods()[0].getDeclaringClass().getName().getFullName().equals(packageName + ".RenamedJavaTestSource.InnerClass"))){
            passed = false;
            log("getDeclaringClass failed: " + innerClass.getMethods()[0].getDeclaringClass().getName().getFullName());
        }
        
        clazz.setName(Identifier.create("Foo"));
        if (!(innerClass.getMethods()[0].getDeclaringClass().getName().getFullName().equals(packageName + ".Foo.InnerClass"))){
            passed = false;
            log("getDeclaringClass failed:" + innerClass.getMethods()[0].getDeclaringClass().getName().getFullName());
        }
        
        clazz.setName(Identifier.create("RenamedJavaTestSource"));
        
        return passed;
    }
    
    /**
     */
    protected void setUp() {
        super.setUp();
        name = "JavaTestSourceInnerClasses";
        packageName = "org.netbeans.test.java.testsources";
    }
    
    /** Generates SimpleJavaTestSourceEtalon
     * @param clazz where to generate
     * @throws Exception
     */
    public static void simpleJavaSourceEtalonGenerator(org.openide.src.ClassElement clazz) throws Exception {
        
        clazz.removeConstructors(clazz.getConstructors());
        clazz.addMethod(Common.createMethod("method1", Modifier.PUBLIC | Modifier.STATIC, Type.INT, Common.PARS1));
        clazz.addField(Common.createField("field1",Modifier.PUBLIC | Modifier.STATIC, Type.FLOAT));
        clazz.addInitializer(Common.createInitializer());
        clazz.addMethod(Common.createMethod("method1", Modifier.PUBLIC | Modifier.STATIC, Type.INT, Common.PARS2));
        clazz.addField(Common.createField("field2",Modifier.PUBLIC | Modifier.STATIC, Type.INT));
        clazz.addConstructor(Common.createConstructor(clazz.getName()));
        clazz.addConstructor(Common.createConstructor(clazz.getName(),Common.PARS1));
        
        clazz.addMethod(Common.createMethod("method1", Modifier.PUBLIC | Modifier.STATIC, Type.INT, Common.PARS3));
        clazz.addInitializer(Common.createInitializer());
        clazz.addMethod(Common.createMethod("method2", Modifier.PUBLIC | Modifier.STATIC, Type.INT, Common.PARS1));
        clazz.addField(Common.createField("field3",Modifier.PUBLIC | Modifier.STATIC, Type.SHORT));
        clazz.addConstructor(Common.createConstructor(clazz.getName(),Common.PARS2));
        clazz.addMethod(Common.createMethod("method2", Modifier.PUBLIC | Modifier.STATIC, Type.SHORT, Common.PARS2));
        clazz.addInitializer(Common.createInitializer());
        clazz.addMethod(Common.createMethod("method2", Modifier.PUBLIC | Modifier.STATIC, Type.LONG, Common.PARS3));
        
    }
    
}
