/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.java.generating.javadoc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import junit.textui.TestRunner;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.test.java.Common;
import org.netbeans.test.java.LogTestCase;
import org.netbeans.test.java.Utilities;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;


import org.openide.src.ClassElement;
import org.openide.src.SourceException;


public class JavaDoc extends LogTestCase {
    
    private static final String TEST_FILE = "TestFile";
    ClassElement clazz;
    File tempFile;
    
    /** Need to be defined because of JUnit */
    public JavaDoc(String name) {
        super(name);
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite("org.netbeans.test.java.generating.javadoc.JavaDoc");
        suite.addTest(new JavaDoc("testClass"));
        suite.addTest(new JavaDoc("testMethod"));
        suite.addTest(new JavaDoc("testField"));
        //suite.addTest(new JavaDoc("testInitializer"));
        suite.addTest(new JavaDoc("testConstructor"));
        return suite;
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        TestRunner.run(suite());
    }
    
    public void setUp() {
        super.setUp();
        FileObject artefact=null;
        try {
            artefact=FileUtil.toFileObject(classPathWorkDir);
        } catch (Exception ex) {
            ex.printStackTrace(log);
            assertTrue(ex.toString(), false);
        }
        
        clazz = ClassElement.forName(getClass().getPackage().getName() + "." + TEST_FILE, artefact);
        clazz.getSource().prepare().waitFinished();
    }
    
    public void tearDown() {
        Utilities.saveAll();
        super.tearDown();
        //Utilities.delete(tempFile);
    }
    
    public void testClass() throws SourceException {
        clazz.getJavaDoc().setRawText("This is TestFile");
        writeResult();
    }
    
    public void testMethod() throws SourceException {
        clazz.getMethods()[0].getJavaDoc().setRawText("test method");
        writeResult();
    }
    
    public void testField() throws SourceException {
        clazz.getFields()[0].getJavaDoc().setRawText("test field");
        writeResult();
    }
    
    public void testInitializer() throws SourceException {
        clazz.getInitializers()[0].getJavaDoc().setRawText("test initializer");
        writeResult();
    }
    
    public void testConstructor() throws SourceException {
        clazz.getConstructors()[0].getJavaDoc().setRawText("test constructor");
        writeResult();
    }
    
    protected boolean writeResult() {
        String result="";
        try {
            DataObject DO = (DataObject) clazz.getSource().getCookie(DataObject.class);
            EditorCookie ec=(EditorCookie)(DO.getCookie(EditorCookie.class));
            javax.swing.text.StyledDocument doc=ec.openDocument();
            result=doc.getText(0, doc.getLength());
            result=Common.unify(result);
        } catch (Exception e){
            e.printStackTrace(log);
            return false;
        }
        ref(result);
        return true;
    }
}
