/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.java.gui.overridemethods;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.actions.ActionNoBlock;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.jellytools.modules.java.OverrideMethodsOperator;
import org.netbeans.jellytools.ProjectsTabOperator;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.TestOut;
import javax.swing.tree.TreeModel;
import org.netbeans.jellytools.EditorOperator;
import org.netbeans.jellytools.actions.OpenAction;
import org.netbeans.test.java.Utilities;
import org.netbeans.test.java.gui.GuiUtilities;

/**
 * Test of the OverrideMethodsDialog for 4.x.
 * @author Roman Strobl
 */
public class OverrideMethodsDialog extends JellyTestCase {
    
    // name of sample project
    private static final String TEST_PROJECT_NAME = "default";
    
    // path to sample files
    private static final String TEST_PACKAGE_PATH =
            "org.netbeans.test.java.gui.overridemethods";
    
    // name of sample package
    private static final String TEST_PACKAGE_NAME = TEST_PACKAGE_PATH+".test";
    
    // name of sample class
    private static final String TEST_CLASS_NAME = "TestClass";
    
    /**
     * error log
     */
    protected static PrintStream err;
    /**
     * standard log
     */
    protected static PrintStream log;

    // workdir, default /tmp, changed to NBJUnit workdir during test
    private String workDir = "/tmp";
    
    // actual directory with project
    private static String projectDir;
    
    /** Needs to be defined because of JUnit 
     * @param name name of testsuite
     */
    public OverrideMethodsDialog(String name) {
        super(name);
    }
    
    /**
     * The test suite
     * @return suite
     */
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new OverrideMethodsDialog("testOverrideMethods"));
        return suite;
    }
    
    /**
     * Use for execution inside IDE
     * @param args command line arguments
     */
    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }        
    
    /** setUp method  */
    public void setUp() {
        System.out.println("########  "+getName()+"  #######");
        err = getLog();
        log = getRef();        
        JemmyProperties.getProperties().setOutput(new TestOut(null, 
                new PrintWriter(err, true), new PrintWriter(err, false), null));
        try {
            File wd = getWorkDir();
            workDir = wd.toString();
        } catch (IOException e) { }        
    }
    
    /**
     * Launches the override methods test.
     */
    public void testOverrideMethods() {                
        Node pn = new ProjectsTabOperator().getProjectRootNode(
                TEST_PROJECT_NAME);
        pn.select();

        Node n = new Node(pn, Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle",
                "NAME_src.dir")+"|"+TEST_PACKAGE_NAME+"|"
                +TEST_CLASS_NAME);
        
        n.select();
        new OpenAction().perform();
        
        Node parent = new Node(pn, Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle", 
                "NAME_src.dir")+"|"+TEST_PACKAGE_NAME);

        // wait for class to appear
        GuiUtilities.waitForChildNode(TEST_PROJECT_NAME, 
                Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle", 
                "NAME_src.dir")+"|"+TEST_PACKAGE_NAME+"|"
                +TEST_CLASS_NAME, TEST_CLASS_NAME);
        Node n2 = new Node(pn, Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle", 
                "NAME_src.dir")+"|"+TEST_PACKAGE_NAME+"|"
                +TEST_CLASS_NAME+"|"+TEST_CLASS_NAME); 
        n2.select();
        new ActionNoBlock("Source|Override Methods...", null).perform(n2);
                        
        Utilities.takeANap(1000);
        
        // customize it
        final OverrideMethodsOperator omo = new OverrideMethodsOperator();
        TreeModel tm = omo.treeAvailableSuperclassAndInterfaceMethods().
                getModel();                
        Object root = tm.getRoot();

        // wait for nodes to be available
        while (tm.getChildCount(root)<5) {
            Utilities.takeANap(1000);
        }
        
        // check descriptions of rows
        assertEquals(tm.getChild(root, 0).toString(), 
                "clone() : java.lang.Object");
        assertEquals(tm.getChild(root, 1).toString(), 
                "equals(Object) : boolean");
        assertEquals(tm.getChild(root, 2).toString(), 
                "finalize() : void");
        assertEquals(tm.getChild(root, 3).toString(), 
                "hashCode() : int");
        assertEquals(tm.getChild(root, 4).toString(), 
                "toString() : java.lang.String");
        
        omo.checkShowAbstractMethodsOnly(true);
        assertEquals(tm.getChildCount(root), 0);
        
        omo.checkShowAbstractMethodsOnly(false);
        omo.checkShowSuperclassesAndInterfaces(true);
        
        Utilities.takeANap(1000);
        
        // check if all rows are available
        omo.treeAvailableSuperclassAndInterfaceMethods().selectRow(0);
        omo.treeAvailableSuperclassAndInterfaceMethods().selectRow(1);
        omo.treeAvailableSuperclassAndInterfaceMethods().selectRow(2);
        omo.treeAvailableSuperclassAndInterfaceMethods().selectRow(3);
        omo.treeAvailableSuperclassAndInterfaceMethods().selectRow(4);
        
        int[] indexes = {1, 2, 3, 4, 5};
        
        // select all rows
        omo.treeAvailableSuperclassAndInterfaceMethods().
                setSelectionRows(indexes);
        
        omo.checkCopyJavadoc(true);
        omo.checkGenerateSuperCalls(true);

        omo.checkCopyJavadoc(false);
        
        omo.ok();

        ref(new EditorOperator(TEST_CLASS_NAME).getText());
        
        compareReferenceFiles();                                
    }

}
