 /*
  * The contents of this file are subject to the terms of the Common Development
  * and Distribution License (the License). You may not use this file except in
  * compliance with the License.
  *
  * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
  * or http://www.netbeans.org/cddl.txt.
  * 
  * When distributing Covered Code, include this CDDL Header Notice in each file
  * and include the License file at http://www.netbeans.org/cddl.txt.
  * If applicable, add the following below the CDDL Header, with the fields
  * enclosed by brackets [] replaced by your own identifying information:
  * "Portions Copyrighted [year] [name of copyright owner]"
  *
  * The Original Software is NetBeans. The Initial Developer of the Original
  * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
  * Microsystems, Inc. All Rights Reserved.
  */

package org.netbeans.test.java.gui.wizards;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.netbeans.jellytools.EditorOperator;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jellytools.ProjectsTabOperator;
import org.netbeans.jellytools.actions.OpenAction;
import org.netbeans.jellytools.actions.SaveAction;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jemmy.EventTool;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.junit.NbTestSuite;



/**
 * Tests Java Elements.
 * @author Roman Strobl
 */
public class JavaElementsTest extends JellyTestCase {
    
    // default timeout for actions in miliseconds
    private static final int ACTION_TIMEOUT = 1000;
    
    // name of sample project
    private static final String TEST_PROJECT_NAME = "default";
    
    // path to sample files
    private static final String TEST_PACKAGE_PATH =
            "org.netbeans.test.java.gui.wizards";
    
    // name of sample package
    private static final String TEST_PACKAGE_NAME = TEST_PACKAGE_PATH+".test";
    
    // name of sample class
    private static final String TEST_CLASS_NAME = "TestClass";
    
    // name of sample field
    private static final String TEST_FIELD_NAME = "testField";
    
    // name of sample parameter
    private static final String TEST_PARAMETER_NAME = "testParameter";
    
    // name of sample method
    private static final String TEST_METHOD_NAME = "testMethod";
    
    // name of sample inner class
    private static final String TEST_INNER_CLASS_NAME = "testInnerClass";
    
    // name of sample inner interface
    private static final String TEST_INNER_INTERFACE_NAME =
            "testInnerInterface";
    
    /**
     * error log
     */
    protected static PrintStream err;
    /**
     * standard log
     */
    protected static PrintStream log;
    
    // workdir, default /tmp, changed to NBJUnit workdir during test
    private String workDir = "/tmp";
    
    private static String projectDir;
    
    /**
     * Adds tests into the test suite.
     * @return suite
     */
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new JavaElementsTest("testNewInitializer"));
        suite.addTest(new JavaElementsTest("testNewField"));
        suite.addTest(new JavaElementsTest("testNewConstructor"));
        suite.addTest(new JavaElementsTest("testNewMethod"));
        suite.addTest(new JavaElementsTest("testNewInnerClass"));
        suite.addTest(new JavaElementsTest("testNewInnerInterface"));
        return suite;
    }
    
    /**
     * Main method for standalone execution.
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    /**
     * Sets up logging facilities.
     */
    public void setUp() {
        System.out.println("########  "+getName()+"  #######");
        err = getLog();
        log = getRef();
        JemmyProperties.getProperties().setOutput(new TestOut(null,
                new PrintWriter(err, true), new PrintWriter(err, false), null));
        try {
            File wd = getWorkDir();
            workDir = wd.toString();
        } catch (IOException e) { }
    }
    
    /**
     * Creates a new instance of JavaElementsTest
     * @param testName name of test
     */
    public JavaElementsTest(String testName) {
        super(testName);
    }
    
    /**
     * New initializer test.
     */
    public void testNewInitializer() {
        Node pn = new ProjectsTabOperator().getProjectRootNode(
                TEST_PROJECT_NAME);
        pn.select();

        Node n = new Node(pn, org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle",
                "NAME_src.dir")+"|"+TEST_PACKAGE_NAME+"|"
                +TEST_CLASS_NAME);
        
        n.select();
        new OpenAction().perform();
        
        new EventTool().waitNoEvent(ACTION_TIMEOUT);
        
        Node n2 = new Node(pn, org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle",
                "NAME_src.dir")+"|"+TEST_PACKAGE_NAME+"|"
                +TEST_CLASS_NAME+"|"+TEST_CLASS_NAME);
        n2.select();
        
        // add new static block
        n2.performPopupAction(org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.ui.nodes.elements.Bundle", "LAB_Add")+"|"+
                org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.ui.nodes.elements.Bundle", "MENU_CREATE_BLOCK"));
        
        // check generated source
        String text = new EditorOperator(TEST_CLASS_NAME).getText();
        log(text);
        // check if static block is present
        /*int index = text.indexOf(org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.ui.nodes.elements.Bundle",
                "SHORT_initializerElementFormat"));*/
        assertTrue("Static block not found.", text.matches("(?s).*static\\s*\\{\\s*\\}.*"));
        
        //new SaveAction().perform();
        EditorOperator editor = new EditorOperator(TEST_CLASS_NAME);
        String s = editor.getText();
        editor.save();
    }
    
    /**
     * New field test.
     */
    public void testNewField() {
        Node pn = new ProjectsTabOperator().getProjectRootNode(
                TEST_PROJECT_NAME);
        pn.select();
        
        Node n = new Node(pn, org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle",
                "NAME_src.dir")+"|"+TEST_PACKAGE_NAME+"|"
                +TEST_CLASS_NAME+"|"+TEST_CLASS_NAME);
        n.select();
        
        // add new field
        n.performPopupActionNoBlock(org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.ui.nodes.elements.Bundle", "LAB_Add")+"|"
                +org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.ui.nodes.elements.Bundle", "MENU_CREATE_VARIABLE"));
        
        NbDialogOperator nb = new NbDialogOperator(
                org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.ui.nodes.elements.Bundle",
                "TIT_NewField"));
        
        JTextFieldOperator tfp = new JTextFieldOperator(nb, 0);
        tfp.setText(TEST_FIELD_NAME);
        
        nb.ok();
        
        // check generated source
        String text = new EditorOperator(TEST_CLASS_NAME).getText();
        log(text);
        // check if static block is present
        //int index = text.indexOf(TEST_FIELD_NAME);
        assertTrue("New field not found.", text.matches("(?s).*int\\s+"+TEST_FIELD_NAME+".*"));
        
        //new SaveAction().perform();
        EditorOperator editor = new EditorOperator(TEST_CLASS_NAME);
        String s = editor.getText();
        editor.save();
    }
    
    /**
     * New constructor test.
     */
    public void testNewConstructor() {
        Node pn = new ProjectsTabOperator().getProjectRootNode(
                TEST_PROJECT_NAME);
        pn.select();
        
        Node n = new Node(pn, org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle",
                "NAME_src.dir")+"|"+TEST_PACKAGE_NAME+"|"
                +TEST_CLASS_NAME+"|"+TEST_CLASS_NAME);
        n.select();
        
        // add a constructor
        n.performPopupActionNoBlock(org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.ui.nodes.elements.Bundle", "LAB_Add")+"|"
                +org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.ui.nodes.elements.Bundle",
                "MENU_CREATE_CONSTRUCTOR"));
        
        NbDialogOperator nb = new NbDialogOperator(
                org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.ui.nodes.elements.Bundle",
                "TIT_NewConstructor"));
        
        JButtonOperator jbo = new JButtonOperator(nb,
                org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.ui.nodes.editors.Bundle",
                "CTL_Add"));
        
        jbo.pushNoBlock();
        
        // choose constructor parameters
        NbDialogOperator nb2 = new NbDialogOperator(
                org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.ui.nodes.editors.Bundle",
                "LAB_EnterParameter"));
        
        JComboBoxOperator jco = new JComboBoxOperator(nb2);
        jco.selectItem("String");
        
        JTextFieldOperator jtfo2 = new JTextFieldOperator(nb2, 1);
        jtfo2.setText(TEST_PARAMETER_NAME);
        
        nb2.ok();
        
        nb.ok();
        
        // check generated source
        String text = new EditorOperator(TEST_CLASS_NAME).getText();
        log(text);
        // check if static block is present
        /*int index = text.indexOf(TEST_CLASS_NAME+"(String "
                +TEST_PARAMETER_NAME+")");
        assertTrue("New constructor not found.", index>-1);*/
        assertTrue("New constructor not found.", text.matches("(?s).*"+TEST_CLASS_NAME+"\\s*\\(String\\s+"+TEST_PARAMETER_NAME+"\\s*\\).*"));
        //new SaveAction().perform();
        EditorOperator editor = new EditorOperator(TEST_CLASS_NAME);
        String s = editor.getText();
        editor.save();
    }
    
    /**
     * New method test.
     */
    public void testNewMethod() {
        Node pn = new ProjectsTabOperator().getProjectRootNode(
                TEST_PROJECT_NAME);
        pn.select();
        
        Node n = new Node(pn, org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle",
                "NAME_src.dir")+"|"+TEST_PACKAGE_NAME+"|"
                +TEST_CLASS_NAME+"|"+TEST_CLASS_NAME);
        n.select();
        
        // open new method
        n.performPopupActionNoBlock(org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.ui.nodes.elements.Bundle", "LAB_Add")+"|"
                +org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.ui.nodes.elements.Bundle",
                "MENU_CREATE_METHOD"));
        
        NbDialogOperator nb = new NbDialogOperator(
                org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.ui.nodes.elements.Bundle",
                "TIT_NewMethod"));
        
        JButtonOperator jbo = new JButtonOperator(nb,
                org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.ui.nodes.editors.Bundle",
                "CTL_Add"));
        jbo.pushNoBlock();
        
        // choose parameters
        NbDialogOperator nb2 = new NbDialogOperator(
                org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.ui.nodes.editors.Bundle",
                "LAB_EnterParameter"));
        
        JComboBoxOperator jco = new JComboBoxOperator(nb2);
        jco.selectItem("String");
        
        JTextFieldOperator jtfo2 = new JTextFieldOperator(nb2, 1);
        jtfo2.setText(TEST_PARAMETER_NAME);
        
        nb2.ok();
        
        JTextFieldOperator jtfo3 = new JTextFieldOperator(nb, 0);
        jtfo3.setText(TEST_METHOD_NAME);
        
        nb.ok();
        
        // check generated source
        String text = new EditorOperator(TEST_CLASS_NAME).getText();
        log(text);
        // check if new method is present
        /*int index = text.indexOf(TEST_METHOD_NAME+"(String "
                +TEST_PARAMETER_NAME+")");
        assertTrue("New method not found.", index>-1);*/
        assertTrue("New method not found.", text.matches("(?s).*"+TEST_METHOD_NAME+"\\s*\\(String\\s+"+TEST_PARAMETER_NAME+"\\s*\\).*"));
        //new SaveAction().perform();
        EditorOperator editor = new EditorOperator(TEST_CLASS_NAME);
        String s = editor.getText();
        editor.save();
    }
    
    /**
     * New inner class test.
     */
    public void testNewInnerClass() {
        Node pn = new ProjectsTabOperator().getProjectRootNode(
                TEST_PROJECT_NAME);
        pn.select();
        
        Node n = new Node(pn, org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle",
                "NAME_src.dir")+"|"+TEST_PACKAGE_NAME+"|"
                +TEST_CLASS_NAME+"|"+TEST_CLASS_NAME);
        n.select();
        
        // open new inner class
        n.performPopupActionNoBlock(org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.ui.nodes.elements.Bundle", "LAB_Add")+"|"
                +org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.ui.nodes.elements.Bundle",
                "MENU_CREATE_INNERCLASS"));
        
        NbDialogOperator nb = new NbDialogOperator(
                org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.ui.nodes.elements.Bundle",
                "TIT_NewInnerClass"));
        
        // choose parameters
        JTextFieldOperator jtfo3 = new JTextFieldOperator(nb, 0);
        jtfo3.setText(TEST_INNER_CLASS_NAME);
        
        nb.ok();
        
        // check generated source
        String text = new EditorOperator(TEST_CLASS_NAME).getText();
        log(text);
        // check if inner class is present
        //int index = text.indexOf(TEST_CLASS_NAME);
        assertTrue("New inner class not found.", text.matches("(?s).*class\\s+"+TEST_INNER_CLASS_NAME+"\\s+.*"));
        
        //new SaveAction().perform();
        EditorOperator editor = new EditorOperator(TEST_CLASS_NAME);
        String s = editor.getText();
        editor.save();
    }
    
    /**
     * New inner interface test.
     */
    public void testNewInnerInterface() {
        Node pn = new ProjectsTabOperator().getProjectRootNode(
                TEST_PROJECT_NAME);
        pn.select();
        
        Node n = new Node(pn, org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle",
                "NAME_src.dir")+"|"+TEST_PACKAGE_NAME+"|"
                +TEST_CLASS_NAME+"|"+TEST_CLASS_NAME);
        n.select();
        
        // open new inner interface
        n.performPopupActionNoBlock(org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.ui.nodes.elements.Bundle", "LAB_Add")+"|"
                +org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.ui.nodes.elements.Bundle",
                "MENU_CREATE_INNERINTERFACE"));
        
        NbDialogOperator nb = new NbDialogOperator(
                org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.ui.nodes.elements.Bundle",
                "TIT_NewInnerInterface"));
        
        // choose parameters
        JTextFieldOperator jtfo3 = new JTextFieldOperator(nb, 0);
        jtfo3.setText(TEST_INNER_INTERFACE_NAME);
        
        nb.ok();
        
        // check generated source
        String text = new EditorOperator(TEST_CLASS_NAME).getText();
        log(text);
        // check if inner interface is present
        //int index = text.indexOf(TEST_INNER_INTERFACE_NAME);
        assertTrue("New inner interface not found.", text.matches("(?s).*interface\\s+"+TEST_INNER_INTERFACE_NAME+"\\s+.*"));
        
        //new SaveAction().perform();
        EditorOperator editor = new EditorOperator(TEST_CLASS_NAME);
        String s = editor.getText();
        editor.save();
    }
        
}
